/*
 * Copyright © 2013 Mike Beattie <mike@ethernal.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

package org.altusmetrum.AltosDroid;

import android.content.Context;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;

public class AltosViewPager extends ViewPager {

    public AltosViewPager(Context context) {
        super(context);
    }

    public AltosViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected boolean canScroll(View v, boolean checkV, int dx, int x, int y) {

	    if (v.getClass() != null &&
		v.getClass().getName() != null &&
		v.getClass().getName().endsWith("MapOffline"))
		    return true;

	    if(v.getClass() != null &&
	       v.getClass().getPackage() != null &&
	       v.getClass().getPackage().getName() != null &&
	       v.getClass().getPackage().getName().startsWith("maps."))
		    return true;

	    return super.canScroll(v, checkV, dx, x, y);
    }

}
