#include <qglobal.h>
#include <qstring.h>

#define LOG_FILE   "/var/log/XFree86.0.log"

class CBoardInfo
{
  public:
            CBoardInfo ( ) ;
    bool    Init ( ) ;
    QString FamilyName    (  ) ;
    QString BoardName     (  ) ;
    QString BusType       (  ) ;
    QString BiosVersion   (  ) ;
    QString ChipType      (  ) ;
    QString ChipRevision  (  ) ;
    QString ChipSpeed     (  ) ;
    QString DacSpeed      (  ) ;
    QString MemoryType    (  ) ;
    QString MemorySize    (  ) ;
    QString MemorySpeed   (  ) ;
    QString TransferMode  (  ) ;
    QString DriverVersion (  ) ;
#ifdef FGLRX_OGL_INFO
    QString OGLVendor     (  ) ;
    QString OGLRenderer   (  ) ;
    QString OGLVersion    (  ) ;
#endif // FGLRX_OGL_INFO

  private:
    int     m_NumBoards ;
    QString m_FamilyName ;
    QString m_BoardName ;
    QString m_BIOSVersion ;
    QString m_ChipType ;
    QString m_ChipRevision ;
    int     m_DacSpeed ;
    QString m_MemoryType;
    int     m_MemorySize ;
    QString m_TransferMode ;
    QString m_DriverVersion ;
#ifdef FGLRX_OGL_INFO
    QString m_OGLVendor;
    QString m_OGLRenderer;
    QString m_OGLVersion;
#endif // FGLRX_OGL_INFO

};

// ATI device IDs
// === R200 ===
#define DEVICE_ID_R200_QH       0x5148  // Function 0, workstation. - current FGL boards
#define DEVICE_ID_R200_QI       0x5149  // Function 0, workstation. - for future use
#define DEVICE_ID_R200_QJ       0x514A  // Function 0, workstation. - for future use
#define DEVICE_ID_R200_QK       0x514B  // Function 0, workstation. - for future use 

#define DEVICE_ID_R200_QL       0x514C  // Function 0, regular.     - consumer div.
#define DEVICE_ID_R200_QT       0x516C  // Function 1, regular.     - consumer div.
#define DEVICE_ID_R200_BB       0x4242  // R200 chip on AiW board with bridget in PCI-PCI bridget mode.

#define DEVICE_ID_R200_QM       0x514D  // Radeon 9100
#define DEVICE_ID_R200_QN       0x514E
#define DEVICE_ID_R200_QO       0x514F

// === RV250 ===
#define DEVICE_ID_RV250_ID      0x4964	// workstation
#define DEVICE_ID_RV250_IE      0x4965  // workstation
#define DEVICE_ID_RV250_IF      0x4966  // regular
#define DEVICE_ID_RV250_IG      0x4967  // regular

#define DEVICE_ID_RV250_IL      0x496C  // workstation
#define DEVICE_ID_RV250_IM      0x496D  // workstation
#define DEVICE_ID_RV250_IN      0x496E  // regular
#define DEVICE_ID_RV250_IO      0x496F  // regular

#define DEVICE_ID_RV250_LD      0x4C64  // mobile workstation
#define DEVICE_ID_RV250_LE      0x4C65  // mobile workstation
#define DEVICE_ID_RV250_LF      0x4C66  // mobile regular
#define DEVICE_ID_RV250_LG      0x4C67  // mobile regular

#define DEVICE_ID_RV250_LL      0x4C6C  // mobile workstation
#define DEVICE_ID_RV250_LM      0x4C6D  // mobile workstation
#define DEVICE_ID_RV250_LN      0x4C6E  // mobile regular
#define DEVICE_ID_RV250_LO      0x4C6F  // mobile regular

// === RV280 ===
#define DEVICE_ID_RV280_5960    0x5960  // RV280 PRO, RV280pro
#define DEVICE_ID_RV280_5961    0x5961  // RV280 Ya, RV280LE, regular
//#define DEVICE_ID_RV280_5962    0x5962
//#define DEVICE_ID_RV280_5963    0x5963

#define DEVICE_ID_RV280_5964    0x5964  // RV280SE

//#define DEVICE_ID_RV280_5C60    0x5C60
#define DEVICE_ID_RV280_5C61    0x5C61  // RV280 M9+
//#define DEVICE_ID_RV280_5C62    0x5C62
#define DEVICE_ID_RV280_5C63    0x5C63  // RV280 M9+

// === R300 ===
#define DEVICE_ID_R300_AD       0x4144
#define DEVICE_ID_R300_AE       0x4145
#define DEVICE_ID_R300_AF       0x4146
#define DEVICE_ID_R300_AG       0x4147  // WS

#define DEVICE_ID_R300_ND       0x4E44
#define DEVICE_ID_R300_NE       0x4E45
#define DEVICE_ID_R300_NF       0x4E46
#define DEVICE_ID_R300_NG       0x4E47  // WS

// === R350 ===
#define DEVICE_ID_R350_AH       0x4148  // regular
//#define DEVICE_ID_R350_AI       0x4149
//#define DEVICE_ID_R350_AJ       0x414A
#define DEVICE_ID_R350_AK       0x414B  // WS

#define DEVICE_ID_R350_NH       0x4E48  // regular
#define DEVICE_ID_R350_NI       0x4E49  // regular
#define DEVICE_ID_R350_NJ       0x4E4A  // regular
#define DEVICE_ID_R350_NK       0x4E4B  // WS

// === RV350 ===
#define DEVICE_ID_RV350_AP      0x4150  // regular
#define DEVICE_ID_RV350_AQ      0x4151  // regular
#define DEVICE_ID_RV350_AR      0x4152  // regular
//#define DEVICE_ID_RV350_AS      0x4153

#define DEVICE_ID_RV350_AT      0x4154  // WS
#define DEVICE_ID_RV350_AU      0x4155  // WS
#define DEVICE_ID_RV350_AV      0x4156  // WS
#define DEVICE_ID_RV350_AW      0x4157  // WS

// === M10 (Mobility version of RV350) ===
#define DEVICE_ID_M10_NP        0x4E50  // regular

#define DEVICE_ID_M10_NT        0x4E54  // WS

// board names
#define ADAPTER_NAME8700LE              "Fire GL 8700LE"
#define ADAPTER_NAME8700                "Fire GL 8700"
#define ADAPTER_NAME8800LE              "Fire GL 8800LE"
#define ADAPTER_NAME8800                "Fire GL 8800"
#define ADAPTER_NAMEE1                  "Fire GL E1"
#define ADAPTER_NAMEZ1AGPPRO            "Fire GL Z1"
#define ADAPTER_NAMEX1AGP               "Fire GL X1"
#define ADAPTER_NAMEX1AGPPRO            "Fire GL X1"

// ATI subedvice IDs for R200
#define SUBSYSTEMID_8700LE              0x0162  // 32 MB
#define SUBSYSTEMID_8700                0x0172  // 64 MB
#define SUBSYSTEMID_8800LE              0x010A  // 64 MB
#define SUBSYSTEMID_8800                0x0152  // 128 MB
#define SUBSYSTEMID_E1                  0x110A  // 64 MB

// ATI subedvice IDs for R300
#define SUBSYSTEMID_FIREGLZ1AGPPRO      0x010A  // 128 MB
#define SUBSYSTEMID_FIREGLX1AGPPRO      0x0152  // 128/256 MB
#define SUBSYSTEMID_OEM1_FIREGLX1AGP    0x0172  // 128 MB (?)

// misc defines
#define MEMORY_TYPE                     L"DDR SDRAM"
#define DAC_SPEED                       400

#define BIOS_PN_PREFIX                  "BIOS P/N "                 // ATI BIOS P/N prefix
#define BIOS_RAGE128_PREFIX             "ATI Technologies Inc. "    // ATI BIOS prefix for pre-production BIOS
#define BIOS_AURORA                     ".AUR"                      // ATI BIOS string to detect Aurora
#define BIOS_STRING_LENGTH              43                          // Max length of ATI BIOS P/N string
#define ADAPTER_STRING_LENGTH           45                          // Max length of Adapter ID

/* ### EOF ### */

