/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*\

File: octtypewin.h

Copyright (c) 2001 Octasic Inc. All rights reserved.

Description: This file defines the base storage types for the Windows 
			 environment.
			 Includes the Windows definition file and add the missing ones here. 

This source code is Octasic Confidential. Use of and access to this code
is covered by the Octasic Device Enabling Software License Agreement. 
Acknowledgement of the Octasic Device Enabling Software License was 
required for access to this code. A copy was also provided with the release.


$Octasic_Release: OCT610xAPI-01.00-PR37 $

$Octasic_Revision: 12 $

\*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/

#ifndef __OCTTYPEWIN_H__
#define __OCTTYPEWIN_H__

/*--------------------------------------------------------------------------
	C language
----------------------------------------------------------------------------*/
#define WIN32_LEAN_AND_MEAN	/* just get the base type definition from Windows */
#include <windows.h>

/* Disable argument not used warning */
#pragma warning( disable : 4100 )
/* Disable Level 4 warning: nonstandard extension used : translation unit is empty */
#pragma warning( disable : 4206 )


#ifdef __cplusplus
extern "C" {
#endif

/* 16-bit integer */
typedef unsigned short	UINT16;
typedef signed short	INT16;
typedef unsigned short	*PUINT16;
typedef signed short	*PINT16;

/* 8-bit integer */
typedef unsigned char	UINT8;
typedef signed char		INT8;
typedef unsigned char	*PUINT8;
typedef signed char		*PINT8;

typedef double			DOUBLE;

/* 32 bit integer */
#if ( defined( _MSC_VER ) && _MSC_VER == 1100 )
/* MFC5 compiler does not define UINT32 */
typedef unsigned int	UINT32;
typedef signed int		INT32;
typedef INT32 *			PINT32;
typedef UINT32 *		PUINT32;
#endif	/* _MSC_VER */

/* LONG LONG */
#define	LLONG			signed __int64
#define	PLLONG			signed __int64 *
#define ULLONG			unsigned __int64
#define PULLONG		    unsigned __int64 * 

#ifndef OPT
#define OPT		/* OPT param */
#endif

typedef	PSZ *	PPSZ;

/*--------------------------------------------------------------------------
	C language
----------------------------------------------------------------------------*/
#ifdef __cplusplus
}
#endif

#endif /* __OCTTYPEWIN_H__ */
