
#ifndef __XFFM_TYPES_H__
#define __XFFM_TYPES_H__
#include <time.h>
#include <sys/types.h>

/* only 2 treeview supported at present time */
enum
{
    RIGHT_TREEVIEW,
    LEFT_TREEVIEW,
    TREECOUNT
};

enum
{
    OTHER_INPUT,
    GOTO_INPUT,
    RUN_INPUT,
    RUN_DOUBLE_CLICK,
    PRINT_INPUT,
    NEW_INPUT,
    NEW_FILE_INPUT,
    NEW_DIR_INPUT,
    RENAME_INPUT,
    DUPLICATE_INPUT,
    SYMLINK_INPUT,
    SCRAMBLE_INPUT,
    UNSCRAMBLE_INPUT,
    WORKDIR_INPUT,
    OPEN_BOOK_INPUT,
    SAVE_BOOK_INPUT,
    NEW_BOOK_INPUT,
    NEW_WIN_INPUT,
    NEW_BOOK_WIN_INPUT,
    NEW_TERM_INPUT,
    FREQUENCY_INPUT,
    RECENT_INPUT
};

typedef struct preferences_t {
  char *label;
  char *xml_option;
  int  flag;
  gint key;
} preferences_t;

typedef struct golist
{
    struct golist *previous;
    struct golist *next;
    char *path;
}
golist;


enum
{
    EMPTY_COLUMN,
    ENTRY_COLUMN,
    STYLE_COLUMN,
    FONT_COLUMN,
    SFONT_COLUMN,
    EDITABLE_COLUMN,
    COLOUR_COLUMN,
    WEIGHT_COLUMN,

    PIXBUF_COLUMN,
    NAME_COLUMN,
    SIZE_COLUMN,
    DATE_COLUMN,
    OWNER_COLUMN,
    GROUP_COLUMN,
    MODE_COLUMN,

    TREE_COLUMNS
};

typedef struct treestuff_t {
    GtkTreeView *treeview;
    GtkTreeModel *treemodel;
    GtkTreeSortable *sortable;
    GtkTreeSelection *selection;

    GtkTreeViewColumn *column[TREE_COLUMNS];
    unsigned preferences;
    golist *gogo;
    gint ascending;
    gint sort_column;
    gint name_size;
}treestuff_t;

typedef struct tree_details_t
{
    /* widgets */
    GtkWidget *window;
    GtkWidget *remove;
    GtkWidget *overwrite;
    /* global options */
    unsigned preferences;
    gchar *theme;
    unsigned recent_days;
    gint frequent_count;
    gchar *argv[2];
    /* geometric stuff */
    gint  geometryX;
    gint  geometryY;
    gint  hpane;
    double hpane_ratio;
    /* smart button status */
    GHashTable *smart_hash;
    /* individual treeview information */
    treestuff_t treestuff[TREECOUNT];
    /* process variables */
    void *tubo_object;
    gint selectionOK;
    gint timer;
    gint input;
    gboolean loading;
    gboolean stop;
    int icon_size;
    gchar *sidebar;

    int comm;
}
tree_details_t;


typedef struct tree_entry_t
{
    int type;
    int subtype;
    int count;		        /* only for directories */
    struct stat *st;
    char *tag;
    char *path;			/* this is just name for trash */
    char *filter;		/* filter for directories, path for trash */
    off_t checksum;		/* only for directories */
    time_t load_time;
}
tree_entry_t;

typedef struct dir_t
{
    char *pathv;		/* matched pathname.  */
    tree_entry_t *en;

}
dir_t;


typedef struct xfdir_t
{
    size_t pathc;		/* Count of paths matched */
    dir_t *gl;
}
xfdir_t;

typedef struct column_info_t
{
    int id;
    GType type;
}
column_info_t;



typedef struct root_t
{
    int id;
    char *path;
    char *label;
    unsigned int type;
}
root_t;

enum
{
    /*ROOT_TASKS,*/
    ROOT_BOOKMARKS,
    ROOT_FILES,
#ifdef USE_SMB_BRANCH
    ROOT_NETWORK,
#endif
    ROOT_FIND,
    ROOT_TRASH,
    ROOT_RECENT,
    ROOT_FREQUENT,
#if defined(HAVE_GETMNTENT) || defined(HAVE_GETFSENT) || defined(HAVE_GETVFSENT)
    ROOT_FSTAB,
#endif
    ROOT_TAGS
};

#endif
