/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

#include <errno.h>


#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "duplicate.h"

#include "cpy.h"
#include "entry.h"
#include "icons.h"
#include "input.h"
#include "misc.h"
#include "monitor.h"
#include "widgets.h"
#include "remove.h"


G_MODULE_EXPORT
int duplicate_it (GtkTreeView * treeview, GtkTreeIter * iter, char *nfile, char *ofile)
{

    struct stat n_st;
    struct stat o_st;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    tree_entry_t *en;

    if(!nfile || !nfile)
	assert_not_reached();
    if(!set_load_wait())
	return FALSE;

    if(lstat(nfile, &n_st) >= 0)
    {
	/*printf ("DBG:query_rm\n");*/
	gboolean overwrite;
	if (lstat(ofile, &o_st) != 0) assert_not_reached();
	 /* dir over dir, do not retry if cannot unlink... */
        if (S_ISDIR(o_st.st_mode) && S_ISDIR(n_st.st_mode)) 
	    overwrite=TRUE; 
	else overwrite=FALSE;
	/* file over dir, file over file, dir over file:
	 * keep retrying if cannot unlink... */
	if (!query_rm(nfile, ofile,overwrite)){
    		    unset_load_wait();
		    return FALSE;
	}	

    }

    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);

	/*printf ("DBG:IndirectTransfer\n");*/
    {
      gchar *fname = SimpleTmpList(nfile, ofile);
      IndirectTransfer(TR_DUPLICATE, fname);
      g_free(fname);
    }

    unset_load_wait();
    return TRUE;

}




G_MODULE_EXPORT
void on_duplicate_activate (GtkMenuItem * menuitem, gpointer user_data)
{
    tree_entry_t *en;
    GtkTreeIter iter;
    en = get_selected_entry(&iter);
    if(!en || !IS_PATH(en->type))
    {
	print_status("xfce/error", strerror(EINVAL), NULL);
	return;
    }
    show_input(DUPLICATE_INPUT);

}
