#include "floatobj.h"

extern QAction* actionEditToggleFloatExport;

/////////////////////////////////////////////////////////////////
// FloatObj
/////////////////////////////////////////////////////////////////

FloatObj::FloatObj ():OrnamentedObj() 
{
//    cout << "Const FloatObj ()\n";
    setParObj (this);	
    init();
    depth=-1;
}

FloatObj::FloatObj (QCanvas* c):OrnamentedObj(c)
{
//	cout << "Const FloatObj (c)  called from MapCenterObj (c)\n";
    setParObj (this);	
    init();
    depth=-1;
}

FloatObj::FloatObj (QCanvas* c, LinkableMapObj* p):OrnamentedObj (c)
{
//    cout << "Const FloatObj (c,p)\n";
    setParObj (p);	
    depth=p->getDepth()+1;
    init();
}

FloatObj::~FloatObj ()
{
//   cout << "Destr FloatObj\n";
}

void FloatObj::init () 
{
    setChildObj(this);
	floatExport=true;
	zPlane=Z_ICON;
	setLinkStyle (StyleParabel);
	setHideLinkUnselected(true);
}

void FloatObj::copy (FloatObj* other)
{
	LinkableMapObj::copy (other);
	setVisibility (other->visible);
}

void FloatObj::setZ(const int &i)
{
	zPlane=i;
}

int FloatObj::z()
{
	return zPlane;
}

void FloatObj::setFloatExport(const bool& b)
{
	floatExport=b;
}

bool FloatObj::getFloatExport()
{
	return floatExport;
}

void FloatObj::move (double x, double y)
{
	MapObj::move(x,y);
	selbox->move(x,y);
}

void FloatObj::move (QPoint p)
{
	move (p.x(), p.y());
}

void FloatObj::setDockPos()
{
	parPos=absPos;
	childPos=absPos;
}

void FloatObj::reposition()
{
	move (parObj->getChildPos().x()+relPos.x(), parObj->getChildPos().y()+relPos.y());
	updateLink();	
}

QRect FloatObj::getTotalBBox()
{
	return bbox;
}

QRect FloatObj::getBBoxSizeWithChilds()
{
	return bboxTotal;
}

void FloatObj::select()
{
    LinkableMapObj::select();
	LinkableMapObj::setLinkColor(parObj->getLinkColor());
}

void FloatObj::unselect()
{
	LinkableMapObj::unselect();
}

