/*
 * This file is part of the QPxTool project.
 * Copyright (C) 2006 Gennady "ShultZ" Kozlov <qpxtool@mail.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */

#include <qcheckbox.h>
//#include <qpushbutton.h>
//#include <qbuttongroup.h>
//#include <qlabel.h>
#include <qmessagebox.h>
#include <qlineedit.h>

//#include <stdlib.h>
#include <qpx_mmc.h>
//#include <plextor_features.h>

#include "SaveHTML.h"

save_html_dialog::save_html_dialog(QWidget* parent, const char* name, bool modal, WFlags fl)
	: save_html_dialog_UI(parent,name,modal,fl)
{
	printf("SaveHTML dialog created\n");
	tests = 0;
}

save_html_dialog::~save_html_dialog()
{
	printf("SaveHTML dialog destroyed\n");
}

void save_html_dialog::setParms(int f_chk, int f_dt)
{
	chk = f_chk;
	dt = f_dt;
	check_cx->setEnabled(false);
	check_jb->setEnabled(false);
	check_ft->setEnabled(false);
	check_ta->setEnabled(false);
	if (dt & DISC_CD) {
		check_rd->setChecked(true);
		if (chk & CHK_CX) {
			check_cx->setEnabled(true);
			check_cx->setChecked(true);
		}
		if (chk & CHK_JB_CD) {
			check_jb->setEnabled(true);
			check_jb->setChecked(true);
		}
		if (chk & CHK_FETE) {
			check_ft->setEnabled(true);
			check_ft->setChecked(true);
		}
	} else if (dt & (DISC_DVDplus | DISC_DVDminus)) {
		check_rd->setChecked(true);
		if (chk & (CHK_PI | CHK_PO)) {
			check_cx->setEnabled(true);
			check_cx->setChecked(true);
		}
		if (chk & CHK_JB_DVD) {
			check_jb->setEnabled(true);
			check_jb->setChecked(true);
		}
		if (chk & CHK_FETE) {
			check_ft->setEnabled(true);
			check_ft->setChecked(true);
		}
		if (chk & CHK_TA) {
			check_ta->setEnabled(true);
			check_ta->setChecked(true);
		}
	}
}

int save_html_dialog::selected()
{
	return tests;
}

QString save_html_dialog::file_name()
{
	return edit_fname->text();
}

void save_html_dialog::savehtml_cancel()
{
	tests = 0;
	this->close();
}

void save_html_dialog::savehtml_save()
{
	tests = 0;
	if (check_rd->isChecked())	tests |= CHK_RD;
	if (check_cx->isChecked())	tests |= (CHK_CX | CHK_PI | CHK_PO);
	if (check_jb->isChecked())	tests |= (CHK_JB_CD | CHK_JB_DVD);
	if (check_ft->isChecked())	tests |= CHK_FETE;
	if (check_ta->isChecked())	tests |= CHK_TA;
	if (!tests) {
		QMessageBox* msg = new QMessageBox (QString("Warning"),
			QString("No tests selected!"),
			QMessageBox::Warning,
			QMessageBox::Ok | QMessageBox::Default | QMessageBox::Escape,
			QMessageBox::NoButton,
			QMessageBox::NoButton,
			this);
		msg->exec();
		delete msg;
		return;
	}
	if (!(edit_fname->text().data()[0])) {
		QMessageBox* msg = new QMessageBox (QString("Warning"),
			QString("No file selected!"),
			QMessageBox::Warning,
			QMessageBox::Ok | QMessageBox::Default | QMessageBox::Escape,
			QMessageBox::NoButton,
			QMessageBox::NoButton,
			this);
		msg->exec();
		delete msg;
		return;
	}
	this->close();
}

void save_html_dialog::savehtml_fselect()
{
	res_name = file_dialog.getSaveFileName("dvd_x.html","*.html");
	if (!res_name.data()) return;
	edit_fname->setText(res_name);
}
