/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: edittransaction.h 406 2007-04-30 18:13:29Z martin $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifndef AQBANKING_KDE_LOADCELLPHONE_H
#define AQBANKING_KDE_LOADCELLPHONE_H

class KBanking;


#include "loadcellphone.ui.h"
#include "refpointer.h"
#include "account.h"

#include <aqbanking/jobloadcellphone.h>



class LoadCellPhone: public LoadCellPhoneUi {
  Q_OBJECT
public:
  LoadCellPhone(KBanking *app,
		QWidget* parent=0,
		const char* name=0,
		bool modal=false,
		WFlags fl=0);
  ~LoadCellPhone();

  static AB_JOB *createJob(KBanking *app,
			   const QString &title,
			   QWidget* parent=0,
			   bool modal=false,
			   WFlags fl=0);

public slots:
  void accept();
  void reject();
  void slotAccountChanged(int i);

private:
  KBanking *_app;

  AB_CELLPHONE_PRODUCT_LIST *_productList;

  Account *_account;
  QString _number;
  AB_CELLPHONE_PRODUCT *_product;
  AB_VALUE *_value;

  void _setComboTextNoDup(QComboBox *qb, const QString &s);
  void _setComboTextIfPossible(QComboBox *qb,
                               const QString &s);
  static QString _tr(const char * sourceText);

};







#endif // AQBANKING_KDE_EDITLOADCELLPHONE_H


