# arch-tag: c33c6f6a-8e62-44e3-916f-5dae4459d7c0
# Copyright (C) 2004 Canonical Ltd.
#               Author: David Allouche <david@canonical.com>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""Run the full test suite within Twisted
"""

from twisted.trial import unittest
from framework_twisted import run_in_thread


class BaseTestSuiteWithTwisted(unittest.TestCase):

    def test_base(self):
        """Base test suite with TwistedSpawningStrategy"""
        run_in_thread(self._base)

    def _base(self):
        print # so the test suite output starts on the next line
        import pybaz
        from pybaz.backends import knotted
        pybaz.backend.spawning_strategy = knotted.TwistedSpawningStrategy
        import pybaz.tests.test_arch
        status = pybaz.tests.test_arch.main([])
        self.assertEqual(0, status)
