/***************************************************************************
*   Copyright (C) 2003 by Christian Nitschkowski                          *
*   segfault_ii@web.de                                                    *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

#include <qlistbox.h>
#include <qpushbutton.h>

#include <kdialog.h>

#include "oooqsselectordialog.h"

OOoQsSelectorDialog::OOoQsSelectorDialog(
    QMap<QString, QString> versions, QWidget* parent,
    const char* name, bool modal, WFlags fl )
		: SelectorDialog( parent, name, modal, fl ) {

	versionList->insertStringList( versions.keys() );
	checkSelection();

	buttonHelp->hide();
	
	KDialog::centerOnScreen(this);
	}

const QString OOoQsSelectorDialog::selected( void ) const {
	return versionList->currentText();
	}

void OOoQsSelectorDialog::checkSelection( void ) {
	buttonOk->setEnabled( versionList->currentText().isNull() ? false : true );
	}

#include "oooqsselectordialog.moc"

