/*
* Copyright (C) 2003 Christian Nitschkowski <segfault_ii@web.de>
*/

#include <qdir.h>
#include <qmap.h>

#include <kaboutdata.h>
#include <kaction.h>
#include <kapp.h>
#include <kglobal.h>
#include <khelpmenu.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kpopupmenu.h>
#include <kprocess.h>
#include <ksimpleconfig.h>

#include "oooqs.h"
#include "oooqsselectordialog.h"

OOoQs::OOoQs()
		: KSystemTray( 0, "OOoQs" ),
_quickProcess( 0 ), _okToRun( true ) {

	QMap<QString, QString> versions;

	KConfig* oooConfig = 0;

	OOoQsSelectorDialog* selector = 0;

	/**
	Get the global config-object.
	*/
	_config = KGlobal::config();
	_config->setGroup( "General" );

	setPixmap( KGlobal::instance() ->iconLoader()
	           ->loadIcon( "oooqs", KIcon::Small ) );

	/**
	Setup the menu.
	*/
	KPopupMenu* menu = contextMenu();

	( new KAction( i18n( "Textdocument" ),
	               "ooo_writer", 0, this,
	               SLOT( startWriter() ), this ) ) ->plug( menu );
	( new KAction( i18n( "Spreadsheet" ),
	               "ooo_calc", 0, this,
	               SLOT( startCalc() ), this ) ) ->plug( menu );
	( new KAction( i18n( "Presentation" ),
	               "ooo_impress", 0, this,
	               SLOT( startImpress() ), this ) ) ->plug( menu );
	( new KAction( i18n( "Drawing" ),
	               "ooo_draw", 0, this,
	               SLOT( startDraw() ), this ) ) ->plug( menu );
	( new KAction( i18n( "From Template" ),
	               "wizard", 0, this,
	               SLOT( startTemplate() ), this ) ) ->plug( menu );
	menu->insertSeparator();
	( new KAction( i18n( "Open Document" ),
	               "fileopen", 0, this,
	               SLOT( startOpen() ), this ) ) ->plug( menu );
	menu->insertSeparator();
	_autostart = new KToggleAction(
	                 i18n( "Start automatically with KDE" ), 0,
	                 this, SLOT( toggleAutostart() ), this );
	_autostart->plug( menu );

	KHelpMenu* tempMenu =
	    new KHelpMenu( this, kapp->aboutData(), false );
	KPopupMenu* helpMenu = tempMenu->menu();

	/**
	Evil hack to get rid of the Help-Index action and the separator.
	*/
	helpMenu->removeItemAt( 0 );
	helpMenu->removeItemAt( 0 );

	menu->insertSeparator();
	menu->insertItem( i18n( "&Help" ), helpMenu );

	/**
	Read the configuration.
	*/
	_autostart->setChecked( _config->readBoolEntry( "Autostart", true ) );
	_exec = _config->readEntry( "Exec" );

	/**
	Try to autodetect settings if they aren't found in our own config.
	*/
	if ( _exec.length() < 2 ) {
		oooConfig = new KSimpleConfig(
		                QDir::homeDirPath() + QDir::separator()
		                + ".sversionrc", true );
		oooConfig->setGroup( "Versions" );
		versions = oooConfig->entryMap( "Versions" );
		/**
		If there are more than one possible configurations,
		ask the user which one to use.
		*/
		if ( versions.count() > 1 ) {
			selector = new OOoQsSelectorDialog( versions, this );
			if ( selector->exec() == QDialog::Accepted ) {
				_exec = versions[ selector->selected() ];
				_exec = _exec.section( ':', 1 );
				_exec += QDir::separator();
				_exec += "soffice";
				_exec = QDir::cleanDirPath( _exec );
				_config->writeEntry( "Exec", _exec );
			} else {
				/**
				Kill the app here if the user hadn't chosen a configuration.
				*/
				_okToRun = false;
				return ;
			}
		/**
		Added by Sergio Visinoni <piffio@piffio.org>
		
		I (Christian) simply forgot it (shame on me!)
		*/
		} else {
			_exec = versions.begin().data();
			_exec = _exec.section( ':', 1 );
			_exec += QDir::separator();
			_exec += "soffice";
			_exec = QDir::cleanDirPath( _exec );
			_config->writeEntry( "Exec", _exec );
		}
	}

	/**
	Make sure that OpenOffice.org is killed
	before the Quickstarter is.
	*/
	connect ( kapp, SIGNAL( shutDown() ),
	          this, SLOT( shutdownAndKillOffice() ) );

	/**
	Start the first quickstart-instance.
	*/
	restartQuickInstance( 0 );
	}

OOoQs::~OOoQs() {
	if ( _quickProcess ) {
		if ( _quickProcess->isRunning() ) {
			if ( KMessageBox::questionYesNo( 0,
			                                 i18n( "There is still at least one (maybe hidden) instance "
			                                       "of OpenOffice.org running that was started by OpenOffice.org Quickstarter.\n"
			                                       "Do you want OpenOffice.org Quickstarter to close it?\n\n"
			                                       "Please make sure that you have saved all open documents "
			                                       "in OpenOffice.org before answering 'yes'!" ),
			                                 i18n( "Running OpenOffice.org detected!" ),
			                                 KStdGuiItem::yes(), KStdGuiItem::no(), "AutoKill" ) == KMessageBox::Yes ) {

				_quickProcess->kill();
				}
			}
		}
	}


void OOoQs::restartQuickInstance( KProcess* process ) {
	/**
	At first, clean up.
	*/
	if ( process ) {
		delete process;
		_quickProcess = 0;
		}

	/**
	Now create the new process...
	*/
	process = new KProcess;
	/**
	... set it up...
	*/
	process->setExecutable( _exec );
	( *process ) << "-plugin";
	( *process ) << "-quickstart";
	connect ( process, SIGNAL( processExited( KProcess* ) ),
	          this, SLOT( restartQuickInstance( KProcess* ) ) );
	/**
	...and finally launch it.
	*/
	process->start();

	/**
	Store the pointer to be able to kill it later if needed.
	*/
	_quickProcess = process;
	}

void OOoQs::start( const QString param ) const {
	KProcess process;
	process.setExecutable( _exec );
	process << param;
	process.start( KProcess::DontCare );
	}

void OOoQs::startCalc( void ) const {
	start( "-calc" );
	}

void OOoQs::startDraw( void ) const {
	start( "-draw" );
	}

void OOoQs::startImpress( void ) const {
	start( "-impress" );
	}

void OOoQs::startOpen( void ) const {
	start( "slot:5501" );
	}

void OOoQs::startTemplate( void ) const {
	start( "slot:5500" );
	}

void OOoQs::startWriter( void ) const {
	start( "-writer" );
	}

void OOoQs::toggleAutostart( void ) {
	/**
	Save the new autostart-setting.
	*/
	_config->setGroup( "General" );
	_config->writeEntry( "Autostart", _autostart->isChecked() );
	_config->sync();
	}

void OOoQs::mousePressEvent( QMouseEvent* event ) {
	/**
	Detect double-clicks.
	*/
	if ( event->type() == QEvent::MouseButtonDblClick ) {
		startTemplate();
		event->accept();
		return ;
		}

	/**
	If there was no double-click, continue normally.
	*/
	KSystemTray::mousePressEvent( event );
	}

void OOoQs::shutdownAndKillOffice( void ) {
	if ( _quickProcess ) {
		_quickProcess->kill();
		}
	}

#include "oooqs.moc"
