/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * Player devices system
 *
 * revision history: (please note changes here)
 *  -nb980510   Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *    -first release
 *  -kb980717   Tammo Hinrichs <opencp@gmx.net>
 *    -changed INI reading of driver symbols to _dllinfo lookup
 */

#define NO_PLRBASE_IMPORT

#include "../config.h"
#include "deviplay.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "types.h"
#include "boot/pmain.h"
#include "filesel/pfilesel.h"
#include "filesel/mdb.h"
#include "filesel/modlist.h"
#include "imsdev.h"
#include "boot/psetting.h"
#include "boot/plinkman.h"
#include "stuff/err.h"
#include "devigen.h"
#include "player.h"
#include "stuff/compat.h"

int (*plrProcessKey)(unsigned short);

struct devinfonode *plPlayerDevices;
int plrBufSize;
static struct devinfonode *curplaydev;
static struct devinfonode *defplaydev;

static struct devinfonode *getdevstr(struct devinfonode *n, const char *hnd)
{
	while (n)
	{
		if (!strcasecmp(n->handle, hnd))
			return n;
		n=n->next;
	}
	return 0;
}

static void setdevice(struct devinfonode **curdev, struct devinfonode *dev)
{
	if (*curdev==dev)
		return;
	if (*curdev)
	{
		if ((*curdev)->addprocs)
			if ((*curdev)->addprocs->Close)
				(*curdev)->addprocs->Close();
		plrProcessKey=0;
		(*curdev)->dev.dev->Close();
		if (!(*curdev)->keep)
		{
			lnkFree((*curdev)->linkhand);
			(*curdev)->linkhand=-1;
		}
	}
	(*curdev)=0;
	if (!dev)
		return;
	if (dev->linkhand<0)
	{
		char lname[12];
		char *dsym;
		strncpy(lname,cfGetProfileString(dev->handle, "link", ""),11);
		dev->linkhand=lnkLink(lname);
		if (dev->linkhand<0)
		{
			fprintf(stderr, "device load error\n");
			return;
		}
		dev->dev.dev=(struct sounddevice *)_lnkGetSymbol(lnkReadInfoReg(dev->linkhand, "driver"));
		if (!dev->dev.dev)
		{
			fprintf(stderr, "device symbol error\n");
			lnkFree(dev->linkhand);
			dev->linkhand=-1;
			return;
		}
		dsym=lnkReadInfoReg(dev->linkhand, "addprocs");
		if (dsym)
			dev->addprocs=0;
		else
			dev->addprocs=(struct devaddstruct *)_lnkGetSymbol(dsym);
	}
	fprintf(stderr, "%s selected...\n", dev->name);
	if (dev->dev.dev->Init(&dev->dev))
	{
		if (dev->addprocs)
			if (dev->addprocs->Init)
				dev->addprocs->Init(dev->handle);
		if (dev->addprocs)
			if (dev->addprocs->ProcessKey)
				plrProcessKey=dev->addprocs->ProcessKey;
		(*curdev)=dev;
		return;
	}
	if (*curdev)
		if (!(*curdev)->keep)
		{
			lnkFree((*curdev)->linkhand);
			(*curdev)->linkhand=-1;
		}
	fprintf(stderr, "device init error\n");
}

void plrSetDevice(const char *name, int def)
{
	setdevice(&curplaydev, getdevstr(plPlayerDevices, name));
	if (def)
		defplaydev=curplaydev;
}

void plrResetDevice(void)
{
	setdevice(&curplaydev, defplaydev);
}

static int playdevinit(void)
{
	const char *def;

#ifdef INITCLOSE_DEBUG
	fprintf(stderr, "playdevinit... trying to init all sound devices [sound]->playerdevices\n");
#endif
	
	if (!strlen(cfGetProfileString2(cfSoundSec, "sound", "playerdevices", "")))
		return errOk;
	fprintf(stderr, "playerdevices:\n");
	if (!deviReadDevices(cfGetProfileString2(cfSoundSec, "sound", "playerdevices", ""), &plPlayerDevices))
	{
		fprintf(stderr, "could not install player devices!\n");
		return errGen;
	}

	curplaydev=0;
	defplaydev=0;

	def=cfGetProfileString("commandline_s", "p", cfGetProfileString2(cfSoundSec, "sound", "defplayer", ""));

	if (strlen(def))
		plrSetDevice(def, 1);
	else
		if (plPlayerDevices)
			plrSetDevice(plPlayerDevices->handle, 1);

	fprintf(stderr, "\n");

	plrBufSize=cfGetProfileInt2(cfSoundSec, "sound", "plrbufsize", 100, 10)*65;
	return errOk;
}

static void playdevclose(void)
{
#ifdef INITCLOSE_DEBUG
	fprintf(stderr, "playdevclose...\n");
#endif
	setdevice(&curplaydev, 0);
	while (plPlayerDevices)
	{
		struct devinfonode *o=plPlayerDevices;
		plPlayerDevices=plPlayerDevices->next;
		free(o);
	}
}

static int plrReadDir(struct modlist *ml, const char *drive, const char *path, const char *mask, unsigned long opt)
{
	struct modlistentry m;

/*  if (opt&RD_PUTDSUBS)
  {
    fsConvFileName12(m.name, "@:", "");
    m.fileref=0xFFFF;
    m.dirref=dmGetDriveDir(0);
    if (!mdbAppendNew(ml, m))
      return 0;
  }*/
	if (strcmp(drive, "setup:"))
		return 1;

	if (opt&RD_PUTSUBS)
	{
		if (!strcmp(path, "/"))
		if ((ml->find(ml, drive, "/DEVICES/"))<0)
		{
/*			m=calloc(1, sizeof(struct modlistentry));*/
			memset(&m, 0, sizeof(m));

			m.drive=drive;
			strcpy(m.name, "DEVICES");
			strcpy(m.shortname, "DEVICES");
			strcpy(m.fullname, "/DEVICES/");
			m.flags=MODLIST_FLAG_DIR;
			ml->append(ml, &m);
		}
			
	}

/*  if (opt&RD_PUTSUBS)
  {
    dmGetPath(path, dirref);
    if (!strcmp(path, "@:\\"))
    {
      fsConvFileName12(m.name, "DEVICES", "");
      dmGetPath(path, dirref);
      strcat(path, "DEVICES");
      m.dirref=dmGetPathReference(path);
      if (m.dirref==0xFFFF)
        return 0;
      m.fileref=0xFFFE;
      if (!mdbAppendNew(ml, m))
        return 0;
    }
  }*/

	if (!strcmp(path, "/DEVICES/"))

	{
		struct devinfonode *dev;
		for (dev=plPlayerDevices; dev; dev=dev->next)
		{
			char hnd[9];
			strcpy(hnd, dev->handle);
/*			strupr(hnd);*/
			memset(&m, 0, sizeof(m));

			fsConvFileName12(m.name, hnd, ".DEV");
/*			if (fsMatchFileName12(m.name, mask))*/
			{
				m.fileref=mdbGetModuleReference(m.name, dev->dev.mem);
				if (m.fileref==0xffffffff)
					return 0;
				m.drive=drive;
/*				m.dirref=dirref;*/
				strncpy(m.shortname, m.name, 12);
				strcpy(m.fullname, "/DEVICES/");
				strcat(m.fullname, hnd);
				strcat(m.fullname, ".DEV");
				m.flags=MODLIST_FLAG_FILE|MODLIST_FLAG_VIRTUAL;
				if (mdbGetModuleType(m.fileref)!=mtDEVp)
				{
					struct moduleinfostruct mi;
					mdbGetModuleInfo(&mi, m.fileref);
					mi.flags1|=MDB_VIRTUAL;
					mi.channels=dev->dev.chan;
					strcpy(mi.modname, dev->name);
					mi.modtype=mtDEVp;
					mdbWriteModuleInfo(m.fileref, &mi);
				}
				ml->append(ml, &m);
			}
		}
	}

/*  dmGetPath(path, dirref);
  if (!strcmp(path, "@:\\DEVICES\\"))
  {
    devinfonode *dev;
    for (dev=plPlayerDevices; dev; dev=dev->next)
    {
      char hnd[9];
      strcpy(hnd, dev->handle);
      strupr(hnd);
      fsConvFileName12(m.name, hnd, ".DEV");
      if (fsMatchFileName12(m.name, mask))
      {
        m.dirref=dirref;
        m.fileref=mdbGetModuleReference(m.name, dev->dev.mem);
        if (m.fileref==0xFFFF)
          return 0;
        if (mdbGetModuleType(m.fileref)!=mtDEVp)
        {
          moduleinfostruct mi;
          mdbGetModuleInfo(mi, m.fileref);
          mi.flags1|=MDB_VIRTUAL;
          mi.channels=dev->dev.chan;
          strcpy(mi.modname, dev->name);
          mi.modtype=mtDEVp;
          mdbWriteModuleInfo(m.fileref, mi);
        }
        if (!mdbAppend(ml, m))
          return 0;
      }
    }
  }*/

	return 1;
}

static int plrSet(const char *path, struct moduleinfostruct *mi, FILE **fp)
{
	char name[9]; /* we never make names that are to big here */
	_splitpath(path, 0, 0, name, 0);
	plrSetDevice(name, 1);
	/*delay(1000); do we really need this ??? (doj)*/
	return 0;
}


static void plrPrep(const char *path, struct moduleinfostruct *m, FILE **fp)
{
	plrResetDevice();
}

struct interfacestruct plrIntr = {plrSet, 0, 0};
struct mdbreaddirregstruct plrReadDirReg = {plrReadDir};

struct initcloseregstruct plrDevReg={playdevinit, playdevclose};
struct preprocregstruct plrPreprocess = {plrPrep};
char *dllinfo = "initclose plrDevReg; interface plrIntr; preprocess plrPreprocess; readdirs plrReadDirReg; interface plrIntr";
struct linkinfostruct dllextinfo = {"plrbase", "OpenCP Player Devices System (c) 1994-04 Niklas Beisert, Tammo Hinrichs", DLLVERSION, 0};
