// BuildPanel.cs
//
// Author:
//   Lluis Sanchez Gual <lluis@novell.com>
//
// Copyright (c) 2008 Novell, Inc (http://www.novell.com)
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
//


using System;
using Gtk;
using MonoDevelop.Core.Gui.Dialogs;

namespace MonoDevelop.Ide.Gui.OptionPanels
{
	internal class BuildPanel : OptionsPanel
	{
		BuildPanelWidget widget;

		public override Widget CreatePanelWidget ()
		{
			return (widget = new  BuildPanelWidget ());
		}

		public override void ApplyChanges ()
		{
			widget.Store ();
		}
	}
	
	internal partial class BuildPanelWidget :  Gtk.Bin 
	{
		public BuildPanelWidget ()
		{
			Build ();
			BeforeCompileAction action = IdeApp.Preferences.BeforeBuildSaveAction;
			saveChangesRadioButton.Active = action == BeforeCompileAction.SaveAllFiles;
			promptChangesRadioButton.Active = action == BeforeCompileAction.PromptForSave;
			noSaveRadioButton.Active = action == BeforeCompileAction.Nothing;
			showTaskListCheckBox.Active = IdeApp.Preferences.ShowErrorsPadAfterBuild;
			showOutputCheckBox.Active = IdeApp.Preferences.ShowOutputPadWhenBuildStarts;
			runWithWarningsCheckBox.Active = IdeApp.Preferences.RunWithWarnings;
			buildBeforeRunCheckBox.Active = IdeApp.Preferences.BuildBeforeExecuting;
			checkXBuild.Active = IdeApp.Preferences.BuildWithMSBuild;
		}
		
		public void Store ()
		{
			IdeApp.Preferences.ShowErrorsPadAfterBuild = showTaskListCheckBox.Active;
			IdeApp.Preferences.ShowOutputPadWhenBuildStarts = showOutputCheckBox.Active;
			IdeApp.Preferences.RunWithWarnings = runWithWarningsCheckBox.Active;
			IdeApp.Preferences.BuildBeforeExecuting = buildBeforeRunCheckBox.Active;
			IdeApp.Preferences.BuildWithMSBuild = checkXBuild.Active;
			
			if (saveChangesRadioButton.Active)
				IdeApp.Preferences.BeforeBuildSaveAction = BeforeCompileAction.SaveAllFiles;
			else if (promptChangesRadioButton.Active)
				IdeApp.Preferences.BeforeBuildSaveAction = BeforeCompileAction.PromptForSave;
			else if (noSaveRadioButton.Active)
				IdeApp.Preferences.BeforeBuildSaveAction = BeforeCompileAction.Nothing;
		}
	}
}
