/**
 * ===========================================
 * LibBase : a free Java utility library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libbase
 *
 * (C) Copyright 2007,2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * LinkedMapTest
 * ------------
 * (C) Copyright 2006, by Pentaho Corporation.
 */


package org.pentaho.reporting.libraries.util;

import java.util.Arrays;

import junit.framework.TestCase;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.LinkedMap;

/**
 * Todo: Document Me
 *
 * @author Thomas Morgner
 */
public class LinkedMapTest extends TestCase
{
  public LinkedMapTest(final String s)
  {
    super(s);
  }

  public void testValidity()
      throws Exception
  {
    final LinkedMap map = new LinkedMap(16, 1024);
    map.put("1", "A");
    map.put("2", "B");
    map.put("3", "C");
    map.put("4", "D");
    map.put("5", "E");
    map.put("6", "F");
    map.put("1", "A");
    final Object[] expectedKeys = {"2", "3", "4", "5", "6", "1"};
    final Object[] a2 = map.keys();
    if (Arrays.equals(expectedKeys, a2) == false)
    {
      throw new Exception();
    }

    if (ObjectUtilities.equal(map.get("1"), "A") == false)
    {
      throw new NullPointerException();
    }
    if (ObjectUtilities.equal(map.get("2"), "B") == false)
    {
      throw new NullPointerException();
    }
    if (ObjectUtilities.equal(map.get("3"), "C") == false)
    {
      throw new NullPointerException();
    }
    if (ObjectUtilities.equal(map.get("4"), "D") == false)
    {
      throw new NullPointerException();
    }
    if (ObjectUtilities.equal(map.get("5"), "E") == false)
    {
      throw new NullPointerException();
    }
    if (ObjectUtilities.equal(map.get("6"), "F") == false)
    {
      throw new NullPointerException();
    }
    if (ObjectUtilities.equal(map.get("1"), "A") == false)
    {
      throw new NullPointerException();
    }


    map.remove("1");
    map.remove("2");


    final Object[] expectedKeys2 = {"3", "4", "5", "6"};
    final Object[] a3 = map.keys();
    if (Arrays.equals(expectedKeys2, a3) == false)
    {
      throw new Exception();
    }

    map.remove("5");
    
    Object[] arrayCache = map.values(new String[map.size()]);

    map.remove("3");
    map.remove("6");
    map.remove("4");

    if (map.keys().length != 0)
    {
      throw new Exception();
    }
  }

}
