/**
 * =========================================
 * LibFormula : a free Java formula library
 * =========================================
 *
 * Project Info:  http://reporting.pentaho.org/libformula/
 *
 * (C) Copyright 2006-2007, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * $Id: OperatorTest.java 7205 2008-12-11 18:20:27Z tmorgner $
 * ------------
 * (C) Copyright 2006-2007, by Pentaho Corporation.
 */
package org.pentaho.reporting.libraries.formula.common;

import java.math.BigDecimal;

import junit.framework.Assert;
import org.pentaho.reporting.libraries.formula.FormulaTestBase;
import org.pentaho.reporting.libraries.formula.ContextEvaluationException;

public class OperatorTest extends FormulaTestBase
{
  protected Object[][] createDataTest()
  {
    return new Object[][]
        {
            {"1 + 1", new BigDecimal(2)},
            {"1 - 1", new BigDecimal(0)},
            {"1 = 1", Boolean.TRUE},
            {"1 <> 1", Boolean.FALSE},
            {"1 < 1", Boolean.FALSE},
            {"1 > 1", Boolean.FALSE},
            {"1 >= 1", Boolean.TRUE},
            {"1 <= 1", Boolean.TRUE},
            {"1 * 1", new BigDecimal(1)},
            {"1 ^ 1", new BigDecimal(1.0)},
            {"1 / 1", new BigDecimal(1)},
            {"1%", new BigDecimal("0.01")},
            {"0.1%", new BigDecimal("0.001")}};
  }

  public void testDefault() throws Exception
  {
    runDefaultTest();
  }

  public void testRangeOperator() throws ContextEvaluationException
  {
    final Object resolveReference = getContext().resolveReference(".B4:.B5");
    Assert.assertNotNull("Reference should not be null", resolveReference);
  }
}
