/**
 * =========================================
 * LibFormula : a free Java formula library
 * =========================================
 *
 * Project Info:  http://reporting.pentaho.org/libformula/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * StaticArrayCallback.java
 * ------------
 */

package org.pentaho.reporting.libraries.formula.typing;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.lvalues.StaticValue;

/**
 * An array call-back that copies all contents of the source into a private buffer. 
 *
 * @author Thomas Morgner
 */
public class StaticArrayCallback implements ArrayCallback
{
  private TypeValuePair[][] backend;
  private int rowCount;
  private int colCount;

  public StaticArrayCallback(final ArrayCallback source) throws EvaluationException
  {
    rowCount = source.getRowCount();
    colCount = source.getColumnCount();
    backend = new TypeValuePair[rowCount][colCount];
    for (int row = 0; row < rowCount; row += 1)
    {
      for (int col = 0; col < colCount; col += 1)
      {
        final Type type = source.getType(row, col);
        final Object value = source.getValue(row, col);
        backend[row][col] = new TypeValuePair(type, value);
      }
    }
  }

  public LValue getRaw(final int row, final int column) throws EvaluationException
  {
    return new StaticValue(getValue(row, column), getType(row, column));
  }

  public Object getValue(final int row, final int column) throws EvaluationException
  {
    return backend[row][column].getValue();
  }

  public Type getType(final int row, final int column) throws EvaluationException
  {
    return backend[row][column].getType();
  }

  public int getColumnCount()
  {
    return colCount;
  }

  public int getRowCount()
  {
    return rowCount;
  }
}
