// -*- C++ -*-
/**
 * \file FormPrint.h
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author Allan Rae
 * \author Angus Leeming
 *
 * Full author contact details are available in file CREDITS.
 */

#ifndef FORMPRINT_H
#define FORMPRINT_H

#include "FormDialogView.h"
#include "RadioButtonGroup.h"

namespace lyx {
namespace frontend {

class ControlPrint;
struct FD_print;

/** This class provides an XForms implementation of the FormPrint Dialog.
    The print dialog allows users to print their documents.
 */
class FormPrint
	: public FormController<ControlPrint, FormView<FD_print> > {
public:
	///
	FormPrint(Dialog &);
private:
	/// Apply from dialog
	virtual void apply();
	/// Build the dialog
	virtual void build();
	/// Update the dialog.
	virtual void update();

	/// Filter the inputs on callback from xforms
	virtual ButtonPolicy::SMInput input(FL_OBJECT *, long);

	/// print target
	RadioButtonGroup target_;
	/// all pages or from/to
	RadioButtonGroup all_pages_;
};

} // namespace frontend
} // namespace lyx

#endif // FORMPRINT_H
