/***************************************************************************
 *   Copyright (C) 2005 - 2006 by Christian Muehlhaeuser, Last.fm Ltd.     *
 *   chris@last.fm                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef __SONG__
#define __SONG__

#include <QUrl>

class Song
{
    public:
        Song();

        void fetch( const Song& song );
        bool sameAs( const Song& song );
        void clear();

        const QString artist() const { return m_artist; }
        void setArtist( QString artist ) { m_artist = artist; }

        const QString album() const { return m_album; }
        void setAlbum( QString album ) { m_album = album; }

        const QString track() const { return m_track; }
        void setTrack( QString track ) { m_track = track; }

        const QString station() const { return m_station; }
        void setStation( QString station ) { m_station = station; }

        const QUrl cover() const { return m_cover; }
        void setCover( QString cover ) { m_cover = QUrl( cover ); }
        void setCover( QUrl cover ) { m_cover = cover; }

        const int progress() const { return m_progress; }
        void setProgress( int progress ) { m_progress = progress; }

        const int duration() const { return m_duration; }
        void setDuration( int duration ) { m_duration = duration; }

        const QString artistUrl() const { return m_artistUrl; }
        void setArtistUrl( QString url ) { m_artistUrl = url; }

        const QString albumUrl() const { return m_albumUrl; }
        void setAlbumUrl( QString url ) { m_albumUrl = url; }

        const QString trackUrl() const { return m_trackUrl; }
        void setTrackUrl( QString url ) { m_trackUrl = url; }

    private:
        QString m_artist;
        QString m_album;
        QString m_track;

        QString m_station;
        QUrl m_cover;

        int m_duration;
        int m_progress;

        QString m_artistUrl;
        QString m_albumUrl;
        QString m_trackUrl;
};

#endif
