/***************************************************************************
 *   Copyright (C) 2005 - 2006 by Christian Muehlhaeuser, Last.fm Ltd.     *
 *   chris@last.fm                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include <QObject>
#include <QByteArray>
#include <QUrl>
#include <QHttp>
#include <QThread>

#include "mpglib/interface.h"

class QTcpServer;

class Playlist;
class RtAudio;
class Song;

class WaveThread : public QThread
{
    public:
        void run();
};

class Playback : public QObject
{
    friend class WaveThread;
    Q_OBJECT

    static Playback *s_instance;

    public:
        Playback();
        ~Playback();

        static Playback *instance() { return s_instance; }

        bool startPlayback( QUrl url );
        void stopPlayback();

        bool isPlaying() { return m_playing; }
        int volume() { return m_volume; }
        void setVolume( int percentage ) { m_volume = percentage + 1; }
        void setDirectSkip() { m_directSkip = true; }

        Playlist *playlist() { return m_playlist; }
        Song *playingSong;

    public slots:
        bool initSound();

    private:
        Playlist *m_playlist;
        RtAudio *m_audio;
        WaveThread *waveThread;

        QHttp *m_http;
        QByteArray *m_mp3Buffer;
        static QByteArray *m_waveBuffer;

        QTcpServer *proxyServerSocket;
        QList<QTcpSocket *> proxySocketList;

        bool m_playing;
        bool m_directSkip;
        int m_volume;

        static int audioCallback( char *buffer, int bufferSize, void *data );

        void showErrorCode( int error );

    signals:
        void bufferStatus( int size );
        void bufferUsed( int size );

        void playbackStarting();
        void playbackFinished();

        void proxyClientConnected();
        void proxyClientDisconnected();

    private slots:
        void playlistResult( const Playlist& playlist );

        void dataAvailable( const QHttpResponseHeader& resp );
        void responseHeaderReceived( const QHttpResponseHeader& resp );
        void stateChanged( int state );

        void proxyClientConnect();
        void proxyClientDisconnect();
};

