/*
 * Copyright (C) 2003 Tom Deblauwe <tomNOSPAM.deblauwe@pandora.be>
 */

#ifndef _KSUBTILEPREF_H_
#define _KSUBTILEPREF_H_

#include <kdialogbase.h>
#include <qframe.h>
#include <qcolor.h>
#include <qdatetime.h>
#include <qfile.h>

#include "prefPageEditorDlg.h"
#include "prefPageMPlayerDlg.h"

#include "kprocess.h"

class ksubtilePrefPageOne;
class ksubtilePrefPageTwo;

class ksubtilePreferences : public KDialogBase
{
    Q_OBJECT
public:
    ksubtilePreferences();

    //default values////////////
    static const long pref_DefaultAddNewLength;
    static const QColor pref_NavigatorSubtitleColor;
    static const QColor pref_NavigatorHighlightSubtitleColor;
    static const QColor pref_NavigatorBackgroundColor;
    static const bool pref_NavigatorDisplayText;
    static const long pref_DefaultPasteOffset;

    static const int pref_MPlayerPosition;
    static const bool pref_MPlayerAutomaticResize;

    static QString pref_AudioOutputDriver(void);
    static QString pref_VideoOutputDriver(void);

    static QString readAudioPref(QString);
    static QString readVideoPref(QString);
    
    enum MPlayerPosition
    {
        posTopLeft,
        posTopRight,
        posBottomLeft,
        posBottomRight
    };
    typedef enum MPlayerPosition MPlayerPosition;

    //functions to fill in the preferences dialog and to read those values

    long getDefaultAddNewLength(void);
    void setDefaultAddNewLength(long newLength);

    QColor getNavigatorSubtitleColor(void);
    void setNavigatorSubtitleColor(QColor color);

    QColor getNavigatorHighlightSubtitleColor(void);
    void setNavigatorHighlightSubtitleColor(QColor color);

    QColor getNavigatorBackgroundColor(void);
    void setNavigatorBackgroundColor(QColor color);

    bool getNavigatorDisplayText(void);
    void setNavigatorDisplayText(bool display);

    long getDefaultPasteOffset(void);
    void setDefaultPasteOffset(long newLength);
    
    int getMPlayerPosition(void);
    void setMPlayerPosition(MPlayerPosition pos);

    bool getMPlayerAutomaticResize(void);
    void setMPlayerAutomaticResize(bool automatic);

    QString getAudioOutputDriver(void);
    void setAudioOutputDriver(QString driver);

    QString getVideoOutputDriver(void);
    void setVideoOutputDriver(QString driver);
   
private:
    ksubtilePrefPageOne *m_pageOne;
    ksubtilePrefPageTwo *m_pageTwo;

    //when the user clicks on the defaults button
public slots:
    void slotDefault(void);

};

class ksubtilePrefPageOne : public prefPageEditorDlg
{
    Q_OBJECT
public:
    ksubtilePrefPageOne(QWidget *parent = 0);
    
    virtual void te_editor_defaultOffset_valueChanged(const QTime &);
    virtual void sb_editor_defaultOffset_valueChanged(int);    
    
};

class ksubtilePrefPageTwo : public prefPageMPlayerDlg
{
    Q_OBJECT

public:
    ksubtilePrefPageTwo(QWidget *parent = 0);
    ~ksubtilePrefPageTwo();

    /** Gets the available audio output drivers from mplayer and fills them in the KListView
    */
    void fillInAudioOutputDrivers(void);
    /** Gets the available video output drivers from mplayer and fills them in the KListView
    */
    void fillInVideoOutputDrivers(void);

private:

    // 	KProcess procAudio;
    //     KProcess* procVideo;
    /** Used to collect all output from mplayer in one string.  This is because a receivedStdOut signal
    * is not always sent after eacht line of output from mplayer.  So we collect everything in this string
    * and then we check what we have got if the mplayer process finishes.
    */
    QString receivedAudio;
    QString receivedVideo;

public slots:

    void slotFillInAudioOutputDrivers(KProcess* proc, char* buf, int buflen);
    void slotFillInVideoOutputDrivers(KProcess* proc, char* buf, int buflen);


};

#endif // _KSUBTILEPREF_H_
