/***************************************************************************
                          picturetransferp2p.h -  description
                             -------------------
    begin                : Fri Nov 26 2004
    copyright            : (C) 2004 by Diederik van der Boor
    email                : vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PICTURETRANSFERP2P_H
#define PICTURETRANSFERP2P_H

#include "p2papplication.h"

#include <qstring.h>
#include <qobject.h>

class MsnObject;
class MimeMessage;
class P2PMessage;
class QFile;


/**
 * An application class responsable for picture transfers between clients.
 *
 * @author Diederik van der Boor
 */
class PictureTransferP2P : public P2PApplication
{
  Q_OBJECT

  public:
    // The constructor without msnobject (sufficient for incoming sessions)
                           PictureTransferP2P(const QString &localIP, const QString &contactHandle);
    // The constructor with msnobject to start a session
                           PictureTransferP2P(const QString &localIP, const QString &contactHandle, const QString &msnObject);

    // The destructor
    virtual               ~PictureTransferP2P();

    // Return the application's GUID
    static QString         getAppId();

    // Return the msn object of the picture we're transferring
    QString                getMsnObject() const;

    // Static function to return a file name.
    static QString         getPictureFileName(const MsnObject& msnObject);


  private:

    // Step one of a contact-started chat: the contact invites the user
    void                   contactStarted1_ContactInvitesUser(const MimeMessage& message);
    // Step two of a contact-started chat: the user accepts
    void                   contactStarted2_UserAccepts();
    // Step three of a contact-started chat: the contact confirms the accept
    void                   contactStarted3_ContactConfirmsAccept(const MimeMessage& message);
    // Step four of a contact-started chat: the contact confirms the data-preparation message.
    void                   contactStarted4_ContactConfirmsPreparation();
    // Called when data is received
    void                   gotData(const P2PMessage &message);

    // Step one of a user-started chat: the user invites the contact
    void                   userStarted1_UserInvitesContact();
    // Step two of a user-started chat: the contact accepts
    void                   userStarted2_ContactAccepts(const MimeMessage &message);
    // Step three of a user-started chat: the user prepares for the session
    void                   userStarted3_UserPrepares();


  private:
    // Handle of the file.
    QFile                 *file_;
    // Name of the file where the data should be stored.
    QString                fileName_;
    // MSN Object identifying the object we need to request
    QString                msnObject_;

  signals:
    void                   pictureReceived(const QString& contact, const QString &msnObject);
};

#endif
