
/***************************************************************************
                          emoticoncollection.h  -  description
                             -------------------
    begin                : Mon Apr 15 2002
    copyright            : (C) 2003 by Michael Curtis
    email                : mdcurtis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 **************************************************************************/

#ifndef EMOTICONCOLLECTION_H
#define EMOTICONCOLLECTION_H

#include <qptrlist.h>

#include "emoticon.h"

class EmoticonCollection : public QPtrList<Emoticon>
{
  public:
    // Delete the instance of the emoticon collection
    static void                destroy();
    // Return a singleton instance of the emoticon collection
    static EmoticonCollection* instance();
    // Replace the emoticons in the text with the urls to the emoticon pngs.
    void                       parseEmoticons( QString &text, bool small = false );
    
  private:
    // The constructor
                               EmoticonCollection();
    // The destructor
                              ~EmoticonCollection();
    
  private:
    // The instance of the singleton emoticon collection
    static EmoticonCollection *instance_;
};

#endif

