/***************************************************************************
                          transferwindow.h -  description
                             -------------------
    begin                : Wed Nov 3 2004
    copyright            : (C) 2004 by Diederik van der Boor
    email                : vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TRANSFERMANAGER_H
#define TRANSFERMANAGER_H

#include <kdialogbase.h>

class TransferEntry;
class QFrame;
class QScrollView;
class QVBoxLayout;

/**
 * A file transfer manager (aka download manager) singleton.
 * @author Diederik van der Boor
 */
class TransferWindow : public KDialogBase
{
  Q_OBJECT

  private:
    // Constructor
                             TransferWindow(QWidget *parent = 0, const char *name = 0);
    // Destructor
    virtual                 ~TransferWindow();

  public:
    // Add a new entry
    TransferEntry           *addEntry(QString filename, uint filesize, bool incoming = false);
    // Return an instance of the transfer manager
    static TransferWindow  *instance();
    // Destroy the current instance
    static void              destroy();

  protected slots:
    // The "Clean up" button was pressed.
    virtual void slotUser1();

  private:
    // Instance to the singleron
    static TransferWindow   *onlyInstance_;

    // List of all entries
    QPtrList<TransferEntry>  entryList_;
    // Main widget for entries
    QWidget                 *mainWidgets_;
    // Layout manager
    QVBoxLayout             *mainLayout_;
    // Scrollview
    QScrollView             *scrollView_;
};

#endif
