/***************************************************************************
                          contactframe.h  -  description
                             -------------------
    begin                : Thu Jan 16 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONTACTFRAME_H
#define CONTACTFRAME_H

#include <qimage.h>
#include <qtimer.h>
#include <qwidget.h>

#include "contactframeinterface.h"

// Forward declarations
class ContactBase;
class CurrentAccount;

/**The frame displaying contact information.
  *@author Mike K. Bennett
  */

class ContactFrame : public ContactFrameInterface
{
  Q_OBJECT

  public:
    // The constructor
  	                 ContactFrame(QWidget *parent=0, const char *name=0);
    // The destructor
  	                ~ContactFrame();
    // Activate the frame by giving it a contact
    void             activate(ContactBase *contact);
    // Deactivate (grey-out) the frame when a contact leaves the chat
    void             deactivate();
    // Reactivate the frame when a contact rejoins the chat
    void             reactivate();
    // Return the handle of this frame's contact
    QString          getHandle() const;
    // Whether or not the frame has been activated
    bool             isActivated() const;
    // The user received a message from this contact
    void             messageReceived();
    // Receive notice that the contact is typing
    void             startTyping();

  private: // Private methods
    // Set whether or not the widgets are enabled or disabled
    void             enableWidgets(bool doEnable);
    // Update all the widgets based on the given contact
    void             updateWidgets();

  private slots: // Private slots
    // Email the contact
    void             sendEmail();
    // Show the contact's profile
    void             showProfile();
    // Disable the typing label when the timer has timed out
    void             stopTyping();
    // Update the contact picture
    void             updatePicture();
    // Update the status widgets
    void             updateStatusWidgets();

  private: // Private attributes
    // Whether or not the frame has been activated
    bool             activated_;
    // The contact whom the frame represents
    ContactBase     *contact_;
    // The contact's image
    QImage           contactImage_;
    // A pointer to the current account
    CurrentAccount  *currentAccount_;
    // A timer to time the duration that the typing label is shown
    QTimer           typingTimer_;
};

#endif
