/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#ifndef _DISSERTPARSER_H
#define _DISSERTPARSER_H

#include <qxml.h>

//#include "DDataItem.h"

class QString;
class QStringList;
class DItem;
class DDataControl;
/**
 * This class handles the necessary code for 
 * importing kdissert (.kdi) and knowit (.kno) files
 *
 * @short kdissert and knowit import tools
 * @author Thomas Nagy <tnagy2^8@yahoo.fr>
 * @version 0.3.1
 */
class DissertParser : public QXmlDefaultHandler
{
	public:
		DissertParser(DDataControl *d, int idstart=0, bool importing=false);

		bool startDocument();
		bool startElement( const QString&, const QString&, const QString&, const QXmlAttributes& );
		bool endElement( const QString&, const QString&, const QString& );

		bool characters( const QString& s);

	private:

		bool m_inItem;
		bool m_importing;

		int m_idstart;
		int m_id;
		int m_docversion;

		QString m_str;
		QString m_tmpstr;
		//URLObject m_obj

		int realID(int);
		
		DDataControl* m_datacontrol;
};

#endif // _DISSERTPARSER_H
