#ifndef POP3_H
#define POP3_H

/*
 * autor 
 * Micha Podsiadlik
 * michal at gov.one.pl
 */

#include <qobject.h>
#include <qstring.h>

#include "ssocket.h"


class Pop3Proto: public QObject
{
	Q_OBJECT
		
	public:	
		Pop3Proto(QString name, QString host, int port, QString user, QString password, SecureType type=WithoutEncryption);
		~Pop3Proto();
		void setName(QString name) { this->name=name; };
		void setHost(QString host) { this->host=host; };
		void setPort(int port) { this->port=port; };
		void setUser(QString user) { this->user=user; };
		void setPassword(QString password) { this->password=password; };
		void setLastmails(int lastmails) { this->lastmails=lastmails; };
		void setEncryption(SecureType type);
		QString getName() { return name; };
		QString getHost() { return host; };
		int getPort() { return port; };
		QString getUser() { return user; };
		QString getPassword() { return password; };
		int getLastmails() { return lastmails; };
		void getStats();
		SecureType getEncryption() { return encryption; };
	private:
		SSocket *mailserver;
		enum State {
			None,
			Connecting,
			LoginUser,
			LoginPassword,
			Stat,
			Quit
		} state;
		void writesocket(QString* str);
		QString name, host, user, password;
		int port, lastmails;
		SecureType encryption;
	public slots:
		void connecterror(int error);
		void connected();
		void parsemessage();
	signals:
		void done(int last, int total, int size, QString name);
		
};

#endif

