/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * autor
 * Micha Podsiadlik
 * michal at gov.one.pl
 */


#ifdef EXTERNAL
#include <modules/hint_manager.h>
#else
#include "../hints/hint_manager.h"
#endif
#include <debug.h>

#include <errno.h>

#include "pop3.h"

// dziwne nazewnictwo :|
#define addHintError(x) connectionError(NULL,x)



Pop3Proto::Pop3Proto(QString name, QString host, int port, QString user, QString password, SecureType type): QObject(), encryption(type)
{
	kdebugf();
	this->name=name;
	this->host=host;
	this->port=port;
	this->user=user;
	this->password=password;
	mailserver=new SSocket(this);
	connect(mailserver, SIGNAL(error(int))   , SLOT(connecterror(int)));
	connect(mailserver, SIGNAL(connected())  , SLOT(connected()));
	connect(mailserver  , SIGNAL(readyRead()), SLOT(parsemessage()));

}


Pop3Proto::~Pop3Proto()
{
	delete mailserver;	
}

void Pop3Proto::connecterror(int error)
{
	hint_manager->addHintError(
			tr("Cannot connect to mail server : %0 on account %1").arg(strerror(errno)).arg(name));
	kdebugm(KDEBUG_INFO, "cannot connect\n");
}

void Pop3Proto::connected()
{
	kdebugf();
}

void Pop3Proto::parsemessage()
{
	QString response=mailserver->readLine();
	QString send;
	QStringList arg=QStringList::split(" ", response);


	if(response.find("+OK")<0){
		switch(state){
			case Connecting:
				hint_manager->addHintError(tr("Cannot connect to mail server on account %1").arg(name));
				break;
			case LoginUser:
				hint_manager->addHintError(tr("Bad login to POP server on %0").arg(name));
				break;
			case LoginPassword:
				hint_manager->addHintError(tr("Bad password to POP server on %0").arg(name));
				break;
			case Stat:
				hint_manager->addHintError(tr("Cannot check mail"));
				break;
			default:
				break;
		}
	}
	else {
		switch(state){
			case Connecting:
				send=QString("USER ")+this->user+QString("\r\n");
				writesocket(&send);
				state=LoginUser;
				mailserver->flush();
				break;
			case LoginUser:
				send=QString("PASS ")+this->password+QString("\r\n");
				writesocket(&send);
				state=LoginPassword;
				mailserver->flush();
				break;
			case LoginPassword:
				writesocket(new QString("STAT\r\n"));
				state=Stat;
				mailserver->flush();
				break;
			case Stat:
				emit done(lastmails, arg[1].toInt(), arg[2].toInt(), name);
				lastmails=arg[1].toInt();
				writesocket(new QString("QUIT\r\n"));
				state=Quit;
				break;
			case Quit:
				kdebugm(KDEBUG_INFO, "disconnected from server\n");
			default:
				mailserver->close();
				break;

		}		
	}
}

void Pop3Proto::writesocket(QString* str)
{
	mailserver->writeBlock(str->latin1(), str->length());
}

void Pop3Proto::getStats()
{
	kdebugm(KDEBUG_INFO, "Connecting to: "+host+":%i\n", port);
	state=Connecting;
	mailserver->connectToHost(host, port);
}

void Pop3Proto::setEncryption(SecureType type)
{
	this->encryption=type;
	mailserver->setType(type);
}
