#ifndef MESSAGE_BOX_H
#define MESSAGE_BOX_H

#include <qdialog.h>
#include <qmap.h>

class QGridLayout;
class QLabel;
class QProgressBar;

/**
	Odpowiednik klasy QMessageBox z QT. W zamierzeniu ma
	mie wiksze moliwoci i wygodniejszy interface ni
	orygina.
**/
class MessageBox : public QDialog
{
	Q_OBJECT
	
	private:
		static QMap<QString,MessageBox*> Boxes;
		QProgressBar* Progress;
		QLabel * _pixmap;
		QGridLayout * _grid;
		QString message;
				
	private slots:
		void okClicked();
		void cancelClicked();
		void yesClicked();
		void noClicked();

	protected:
		void closeEvent(QCloseEvent* e);
	
	public:
		// komponenty dialogu
		static const int OK;
		static const int CANCEL;
		static const int YES;
		static const int NO;
		static const int PROGRESS;
		//
		MessageBox(const QString& message,int components = 0, bool modal=false);
		~MessageBox();

		void setTotalSteps(int s);
		void setProgress(int p);
		void setIcon(const QPixmap & pixmap);
		//
		/**
			Informuje uytkownika o wykonywanej przez
			program czynnoci. Tworzy dialog zawierajcy
			tylko podany tekst. Nie blokuje wykonywania
			programu. Zamknicie dialogu nastpuje po
			wywoaniu funkcji close z t sam wiadomoci
			przekazan jako argument.
			Wywouje QApplication::processEvents().
		**/		
		static void status(const QString& message);
		/**
			Zadaje uytkownikowi pytanie. Tworzy dialog
			z dwoma przyciskami: "Tak" i "Nie". Blokuje
			wykonywanie programu i czeka na reakcj
			uytkownika. Zwraca true jeli wybra "Tak"
			lub false jeli wybra "Nie".
		**/
		static bool ask(const QString& message);
		/**
			Przekazuje uytkownikowi informacj. Tworzy
			dialog z przyciskiem: "OK" zamykajcy okno.
			Nie blokuje wykonywania programu.
		**/
		static void msg(const QString& message,bool modal=false);
		/**
			Jak wyej, ale w formie ostrzeenia
		**/
		static void wrn(const QString& message,bool modal=false);
		/**
			Informuje uytkownika o postpie wykonywanej
			przez program czynnoci. Tworzy dialog zawierajcy
			podany tekst, pasek postpu o podanej
			maksymalnej wartoci i opcjonalnie przycisk Anuluj
			podczony do podanego slot'u w podanym obiekcie.
			Nie blokuje wykonywania programu. Zamknicie dialogu
			nastpuje po wywoaniu funkcji close z t sam
			wiadomoci przekazan jako argument.
			Wywouje QApplication::processEvents().
		**/				
		static void progress(const QString& message,
			const QObject* receiver=0,const char* slot=0,
			int total_steps=100);
		/**
			Ustawia podan warto paska postpu w dialogu
			stworzonym za pomoc poprzedniej funkcji z t
			sam wiadomoci przekazan jako argument.
			Wywouje QApplication::processEvents().
		**/
		static void progress(const QString& message,int progress);
		/**
			Zamyka dialog, ktry zosta stworzony za
			pomoc funkcji status z t sam wiadomoci
			przekazan jako argument.
		**/
		static void close(const QString& message);
		
	signals:
		void okPressed();
		void cancelPressed();
		void yesPressed();
		void noPressed();
};

#endif
