/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qfile.h>
#include <qspinbox.h>

#include "mime_tex.h"
#include "tex_formula_dialog.h"

#include "config_dialog.h"
#include "icons_manager.h"
#include "misc.h"
#include "action.h"
#include "chat_manager.h"
#include "debug.h"

MimeTeX::MimeTeX(QObject *parent, const char *name)
: QObject(parent, name)
{
	kdebugf();
	// TODO: Add fonts size and/or color change support
	ConfigDialog::addVGroupBox("PowerKadu", "PowerKadu",
			QT_TRANSLATE_NOOP("@default", "TeX formula support"), NULL, Advanced);
	ConfigDialog::addSpinBox("PowerKadu", "TeX formula support",
			QT_TRANSLATE_NOOP("@default",
			"Formula refreshment interval"), "mimetex_refreshment_interval",
			1000, 20000, 50, 2000, NULL, NULL, Advanced);
	ConfigDialog::addCheckBox("PowerKadu", "TeX formula support",
			QT_TRANSLATE_NOOP("@default", "Remove GIF files on module unload"),
			"mimetex_remove_tmp_files", false, QT_TRANSLATE_NOOP("@default",
			"When this option is set, all formula images will be removed from\n"
			"disk on module unload (e. g. when exiting Kadu). Note that only\n"
			"files from the current PowerKadu session will be removed."), NULL, Advanced);
	
	Action *TeXAction = new Action(icons_manager->loadIcon(dataPath(
			"kadu/modules/data/powerkadu/mime_tex_icons/tex_icon.png")),
				tr("TeX formula"), "tex_action", Action::TypeChat);
	connect(TeXAction, SIGNAL(activated(const UserGroup*, const QWidget*, bool)),
		this, SLOT(TeXActionActivated(const UserGroup*, const QWidget*, bool)));
	ConfigDialog::registerSlotOnCreateTab("PowerKadu", this, SLOT(onCreateTab()));
	KaduActions.insert("tex_action", TeXAction);
	
	kdebugf2();
}

MimeTeX::~MimeTeX()
{
	kdebugf();
	ConfigDialog::unregisterSlotOnCreateTab("PowerKadu", this, SLOT(onCreateTab()));
	ConfigDialog::removeControl("PowerKadu", "Remove GIF files on module unload");
	ConfigDialog::removeControl("PowerKadu", "Formula refreshment interval");
	ConfigDialog::removeControl("PowerKadu", "TeX formula support");
	KaduActions.remove("tex_action");
	if(config_file.readBoolEntry("PowerKadu", "mimetex_remove_tmp_files", false))
	{
		kdebugm(KDEBUG_INFO, "Removing tmp GIFs\n");
		QStringList::ConstIterator it;
		for(it = tmpFiles.begin(); it != tmpFiles.end(); ++it)
		{
			QFile file(*it);
			file.remove();
		}
	}
	kdebugf2();
}

void MimeTeX::TeXActionActivated(const UserGroup *group, const QWidget *actionButton, bool activated)
{
	kdebugf();
	Chat *chat = chat_manager->findChat(group);
	TeXFormulaDialog *formulaDialog = new TeXFormulaDialog(chat, "tex_formula_dialog");
	tmpFiles.append(formulaDialog->getTmpFileName());
	formulaDialog->show();
	kdebugf2();
}

void MimeTeX::onCreateTab()
{
	kdebugf();
	ConfigDialog::getSpinBox("PowerKadu", "Formula refreshment interval")->setSuffix(" ms");
	kdebugf2();
}
