#ifndef AUTOSTATUS_H
#define AUTOSTATUS_H

#include <qobject.h>
#include <qstringlist.h>
#include <qdialog.h>

class PowerKadu;
class QTimer;

/*!
 * This class provides functionality to automaticly change status
 * after served time
 * \brief Automaticly status change class
 */
class Autostatus : public QDialog
{
	Q_OBJECT

	public:
		//! Default constructor.
		Autostatus();

	//! Default destructor.
		~Autostatus();
 
	private:
		void create_gui();
		void kill_gui();

		int menuID;
		int autoStatus;
		int autoTime;
		int currStat;
		QString currDesc;

		QStringList::Iterator it;
		QTimer* timer;
		QStringList statusList;
	
	private slots:
		//! This slot is called when the "PowerKadu" tab is selected in config gialog
		void onCreateTab();

	public slots:
		//! This slot is called when new Autostatus it starts
		void onAutostatus();

		//! This slot is called when timeout
		void changeStatus();
};

#endif
