/*
 * cmd_input_dialog.h - declaration of class cmdInputDialog
 *
 * iTALC
 * Copyright (c) 2004-2005 Tobias Doerffel <tobias@doerffel.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

#ifndef _CMD_INPUT_DIALOG_H
#define _CMD_INPUT_DIALOG_H

#include <qdialog.h>


/*!
  \brief The Command-Input-Dialog

  With the help of this dialog you can input a series of commands, which should be executed on one or more client(s).

  \sa   clientManager for detailed description of management of clients
*/


class QLabel;
class QPushButton;
class QTextEdit;


class cmdInputDialog : public QDialog
{
	Q_OBJECT
public:
	cmdInputDialog( QString & _cmds_str, QWidget * _parent );
	~cmdInputDialog();


private slots:
	virtual void accept( void );


private:
	void keyPressEvent( QKeyEvent * _ke );
	void resizeEvent( QResizeEvent * _re );

	QPushButton * m_cancelBtn;
	QPushButton * m_okBtn;
	QLabel * m_iconLbl;
	QLabel * m_appNameLbl;
	QTextEdit * m_cmdInputTextEdit;

	QString & m_cmdsStr;

} ;

#endif
