/*
 * client_properties_edit.h - declaration of class clientPropertiesEdit, a dialog for editing properties of a client
 *
 * iTALC
 * Copyright (c) 2004-2005 Tobias Doerffel <tobias@doerffel.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#ifndef _CLIENT_PROPERTIES_EDIT_H
#define _CLIENT_PROPERTIES_EDIT_H

#include <qdialog.h>


/*!
  \brief The Client-Properties-Edit-Dialog

  With the help of this dialog you can edit the properties of a client.

  \sa   clientManager for detailed description of management of clients
*/



class client;
class QLabel;
class QLineEdit;
class QPushButton;
class QComboBox;


class clientPropertiesEdit : public QDialog
{
	Q_OBJECT
public:
	clientPropertiesEdit( client * _c, const QString & _group_name, QWidget * _parent );
	~clientPropertiesEdit();


private slots:
	void okBtnClicked( void );


private:
	void keyPressEvent( QKeyEvent * _ke );

	client * m_client;

	QLabel * m_groupLbl;
	QLabel * m_nameLbl;
	QLabel * m_ipLbl;
	QLabel * m_macLbl;

	QComboBox * m_groupBox;
	QLineEdit * m_nameEdit;
	QLineEdit * m_ipEdit;
	QLineEdit * m_macEdit;

	QPushButton * m_okBtn;
	QPushButton * m_cancelBtn;

} ;

#endif
