/*
 * qkey.cpp - stuff for key-management - based on code of kkeynative.cpp, kkeyserver_x11.cpp and kshortcut.cpp of kdelibs/kdecore
 *
 * iTALC
 * Copyright (c) 2004-2005 Tobias Doerffel <tobias@doerffel.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#include "qkey.h"

#define XK_MISCELLANY
#define XK_XKB_KEYS
#include <X11/Xutil.h>



QKey::QKey( const XEvent* pEvent )
{
	m_mod = pEvent->xkey.state;
	XLookupString( (XKeyEvent*) pEvent, 0, 0, (KeySym*) &m_sym, 0 );
}



QKey::~QKey()
{
}



unsigned int QKey::mod() const
{
	return( m_mod );
}



unsigned int QKey::sym() const
{
	return( m_sym );
}




struct ModInfo
{
	QKey::ModFlag mod;
	unsigned int modX;
} static g_rgModInfo[QKey::MOD_FLAG_COUNT] =
{
	{ QKey::SHIFT, ShiftMask },
	{ QKey::CTRL,  ControlMask },
	{ QKey::ALT,   Mod1Mask },
	{ QKey::WIN,   Mod4Mask }
};


unsigned int QKey::modX( QKey::ModFlag modFlag )
{
	for( unsigned int i = 0; i < QKey::MOD_FLAG_COUNT; i++ )
	{
		if( g_rgModInfo[i].mod == modFlag )
			return( g_rgModInfo[i].modX );
	}
	return( 0 );
}
