/*
 * client_viewer_widget.cpp - main-widget of ICV which contains all other widgets and provides general UI
 *
 * iTALC
 * Copyright (c) 2004-2005 Tobias Doerffel <tobias@doerffel.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#include <qapplication.h>
#include <qpushbutton.h>
#include <qscrollview.h>
#include <qpainter.h>

#include "client_viewer_widget.h"
#include "qvncview.h"
#include "embed.h"
#include "misc.h"

#include "client_viewer_widget.moc"


QPixmap * clientViewerWidget::s_topBarPixmap = NULL;

const int TOP_BAR_HEIGHT = 32;
const int HELP_PERSON_FONT_SIZE = 16;
const int HELP_PERSON_X = 130;
const int INFO_FONT_SIZE = 10;


clientViewerWidget::clientViewerWidget( const QString & _pname, const QString & _cip ) :
	QWidget(/* 0, 0, WNoAutoErase*/ ),
	m_helpPersonTxt( "- " + tr( "Help a person" ) ),
	m_pupilName( _pname ),
	m_clientIP( _cip )
{
	if( s_topBarPixmap == NULL )
		s_topBarPixmap = new QPixmap( embed::getIconPixmap( "top_bar" ) );

	setBackgroundMode( Qt::NoBackground );

	setCaption( "iTALC "+m_helpPersonTxt );

	QFont f;
	f.setPointSize( HELP_PERSON_FONT_SIZE );
	f.setBold( TRUE );
	QFontMetrics fm( f );
	m_helpPersonTxtWidth = fm.width( m_helpPersonTxt );


	f.setPointSize( INFO_FONT_SIZE );
	f.setBold( FALSE );
	fm = QFontMetrics( f );

	int bx = HELP_PERSON_X + m_helpPersonTxtWidth + misc::max<int>( fm.width( m_pupilName ), fm.width( m_clientIP ) ) + 40;

	m_quitBtn = new QPushButton( embed::getIconPixmap( "cancel" ), tr( "Quit" ), this );
	m_quitBtn->setGeometry( bx, 4, 120, 24 );
	connect( m_quitBtn, SIGNAL( clicked() ), qApp, SLOT( closeAllWindows() ) );
	
	m_toggleFullScreenBtn = new QPushButton( embed::getIconPixmap( "toggle_fullscreen" ), tr( "Fullscreen" ), this );
	m_toggleFullScreenBtn->setGeometry( bx+140, 4, 120, 24 );
	m_toggleFullScreenBtn->setToggleButton( TRUE );
	m_toggleFullScreenBtn->setOn( TRUE );
	connect( m_toggleFullScreenBtn, SIGNAL( toggled( bool ) ), this, SLOT( toggleFullScreen( bool ) ) );

	m_scrollView = new QScrollView( this );
	m_scrollView->move( 0, TOP_BAR_HEIGHT+1 );
	m_scrollView->setFrameStyle( QFrame::NoFrame );

	m_vncView = new QVncView( m_scrollView, 0, _cip, 5900, QString::null, QUALITY_HIGH, DOT_CURSOR_ON );
	m_vncView->start();
	//m_vncView->enableScaling( TRUE );
	m_scrollView->addChild( m_vncView );

	showMaximized();
	showFullScreen();

	m_vncView->grabKeyboard();
}




clientViewerWidget::~clientViewerWidget()
{

}




void clientViewerWidget::paintEvent( QPaintEvent * )
{
	QPixmap draw_pm( this->rect().size() );
	draw_pm.fill( QColor( 0, 0, 0 ) );

	QPainter p( &draw_pm, this );

	p.drawPixmap( 0, 0, *s_topBarPixmap );

	QFont f;
	f.setPointSize( HELP_PERSON_FONT_SIZE );
	f.setBold( TRUE );
	p.setFont( f );

	p.setPen( QColor( 255, 232, 0 ) );
	p.drawText( HELP_PERSON_X, ( TOP_BAR_HEIGHT+HELP_PERSON_FONT_SIZE ) / 2 - 2, m_helpPersonTxt );


	f.setPointSize( INFO_FONT_SIZE );
	f.setBold( FALSE );
	p.setFont( f );

	int info_x = HELP_PERSON_X+m_helpPersonTxtWidth+15;
	p.setPen( QColor( 0, 255, 0 ) );
	p.drawText( info_x, INFO_FONT_SIZE + 3, m_pupilName );
	p.drawText( info_x, 2*INFO_FONT_SIZE + 7, m_clientIP );
	
	// and blit all drawn stuff on the screen...
	bitBlt( this, this->rect().topLeft(), &draw_pm );
}




void clientViewerWidget::resizeEvent( QResizeEvent * )
{
	m_scrollView->resize( width(), height()-TOP_BAR_HEIGHT );
}




void clientViewerWidget::toggleFullScreen( bool _on )
{
#if QT_VERSION >= 0x030300
	if( _on )
		setWindowState( windowState() | WindowFullScreen );
	else
		setWindowState( windowState() & ~WindowFullScreen );
#else
	if( _on )
		showFullScreen();
	else
		showNormal();
#endif
}


