/*
 * qkey.h - stuff for key-management - based on code of kkeynative.h, kkeyserver_x11.h and kshortcut.h of kdelibs/kdecore
 *
 * iTALC
 * Copyright (c) 2004-2005 Tobias Doerffel <tobias@doerffel.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#ifndef _QKEY_H
#define _QKEY_H


typedef union _XEvent XEvent;


class QKey
{
public:
	enum ModFlag
	{
		SHIFT = 0x01,
		CTRL = 0x02,
		ALT = 0x04,
		WIN = 0x08
	} ;
	enum { MOD_FLAG_COUNT = 4 };
	QKey( const XEvent* xevent );
	~QKey();

	unsigned int mod() const;
	unsigned int sym() const;

	static unsigned int modX( QKey::ModFlag modFlag );

private:
	unsigned int m_mod, m_sym;

};


#endif
