/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * the Mozilla Foundation.
 * Portions created by the Initial Developer are Copyright (C) 2010
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Siddharth Agarwal <sid.bugzilla@gmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

/*
 * Tests for iteratorUtils.jsm. Currently this tests
 * - toArray
 */

var iteratorUtils = {};
Components.utils.import("resource:///modules/iteratorUtils.jsm", iteratorUtils);

var gDOMParser = Cc["@mozilla.org/xmlextras/domparser;1"]
                   .createInstance(Ci.nsIDOMParser);

/**
 * Given the name of an XML file, returns the node representation of the file.
 */
function parse_xml_file(aFileName) {
  let file = do_get_file(aFileName);
  let stream = Cc["@mozilla.org/network/file-input-stream;1"]
                 .createInstance(Ci.nsIFileInputStream);
  stream.init(file, -1, -1, Ci.nsIFileInputStream.CLOSE_ON_EOF);
  return gDOMParser.parseFromStream(stream, "UTF-8", file.fileSize,
                                    "application/xml");
}

/**
 * Test that toArray works correctly with a NodeList.
 */
function test_toArray_NodeList() {
  let xml = parse_xml_file("nodelist_test.xml");
  let rootNode = xml.firstChild;
  // Sanity check -- rootNode should have tag "rootnode"
  do_check_eq(rootNode.tagName, "rootnode");
  // childNodes is a NodeList
  let childNodes = rootNode.childNodes;
  // Make sure we have at least one child node
  do_check_true(childNodes.length > 0);
  let childArray = iteratorUtils.toArray(childNodes);
  do_check_eq(childNodes.length, childArray.length);
  for (let [i, node] in Iterator(childArray))
    do_check_eq(node, childArray[i]);
}

/**
 * Test that toArray works correctly with a built-in iterator generated by an
 * array.
 */
function test_toArray_builtin_iterator() {
  let arr = [11, 12, 13, 14, 15, 16, 17, 18, 19, 20];
  let iterator = Iterator(arr);
  // Note that this is going to be an array of [key, value] pairs, as is
  // returned by Iterator for an array
  let iteratorArray = iteratorUtils.toArray(iterator);
  do_check_eq(arr.length, iteratorArray.length);
  for (let [i, val] in Iterator(arr)) {
    do_check_eq(i, iteratorArray[i][0]);
    do_check_eq(val, iteratorArray[i][1]);
  }
}

/**
 * Test that toArray works correctly with a custom iterator.
 */
function test_toArray_custom_iterator() {
  let arr = [21, 22, 23, 24, 25, 26, 27, 28, 29, 30];
  let iterator = {
    __iterator__: function testIterator() {
      // C-style for loop so that we don't confuse ourselves with yet another
      // iterator
      for (let i = 0; i < arr.length; i++)
        yield arr[i];
    },
  };
  let iteratorArray = iteratorUtils.toArray(iterator);
  do_check_eq(arr.length, iteratorArray.length);
  for (let [i, val] in Iterator(arr))
    do_check_eq(val, iteratorArray[i]);
}

var gTests = [
  test_toArray_NodeList,
  test_toArray_builtin_iterator,
  test_toArray_custom_iterator,
];

function run_test() {
  for (let [, test] in Iterator(gTests))
    test();
}
