package GCPlugins::GCFilmWeb;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;
use utf8;

use GCPlugins::GCPluginsBase;

{
    package GCPlugins::GCPluginFilmWeb;

    use base qw(GCPluginParser);

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;
		
        if ($self->{parsingList})
        {
            if ($self->{parsingEnded})
            {
                if (($tagname eq 'input')
                 && ($attr->{name} eq 'id'))
                {
                    $self->{movieIdx} = 0;
                    $self->{movieList}[0]->{title} = '';
                    $self->{movieList}[0]->{url} = 'http://www.filmweb.pl/Film?id='. $attr->{value};
                }
            }
            
            if (($tagname eq 'img')
             && ($attr->{src} eq 'http://gfx.filmweb.pl/gf/ic/lu.gif')
             && ($self->{insideResults} != -1))
            {
                $self->{insideResults} = 1;
            }
            
            if (($tagname eq 'form')
             && ($self->{insideResults} == 1))
            {
                $self->{insideResults} = -1;
            }
            
            if (($tagname eq 'a')
             && ($self->{insideResults} == 1))
            {
                $self->{isMovie} = 1;
                $self->{movieIdx}++;
                $self->{movieList}[$self->{movieIdx}]->{url} = $attr->{href};
            }
        }
        else
        {
            if ($tagname eq 'div')
            { 
                $self->{isTitle} = 1
                    if ($attr->{class} eq 'tyt');
            }
            elsif ($tagname eq 'span')
            {
                $self->{isOrig} = 1
                    if ($attr->{class} eq 'styt');
            }
            elsif ($tagname eq 'a')
            {
                $self->{isCountry} = 1
                    if (! ($self->{curInfo}->{date} || $self->{curInfo}->{type}))
                    && ($attr->{href} =~ m|http://www\.filmweb\.pl/TopFilm\?country\.id=|);
                $self->{isGenre} = 1
                    if ($attr->{href} =~ m|http://www\.filmweb\.pl/TopFilm\?genre\.id=|);
                if ($attr->{href} =~ m|http://www\.filmweb\.pl/FilmDescriptions|)
                {
                    my $page = $self->loadPage($attr->{href});
                    $page =~ m|<li><div align="justify">(.*?)</div></li>|ms;
                    $self->{curInfo}->{synopsis} = $1;
                    $self->{curInfo}->{synopsis} =~ s/<br\/>/<br>/gi;
                    $self->{curInfo}->{synopsis} =~ s/\n//gm;
                }
            }
            elsif ($tagname eq 'td')
            {
                $self->{isPreDate} = 1
                    if ($attr->{class} eq 'gr3');
                $self->{isImage} = 1
                    if ($attr->{class} eq 'k1');
                $self->{isActors} = 1
                    if ($attr->{width} eq '194')
                    && ($attr->{align} eq 'right');
                    
            }
            elsif ($tagname eq 'b')
            {
                if ($self->{isPreDate})
                {
                    $self->{isDate} = 1;
                    $self->{isPreDate} = 0;
                }
            }
            elsif ($tagname eq 'img')
            {
                if ($self->{isImage})
                {
                    $self->{curInfo}->{image} = $attr->{src};
                    $self->{isImage} = 0;
                }
            }
        }
    }

    sub end
    {
		my ($self, $tagname) = @_;
		
        $self->{inside}->{$tagname}--;
    }

    sub text
    {
        my ($self, $origtext) = @_;

        if ($self->{parsingList})
        {
            if ($self->{inside}->{title})
            {
                $self->{parsingEnded} = 1
                    if $origtext !~ /Filmweb\.pl - /;
            }
            if ($self->{parsingEnded})
            {
                return;
            }
            if ($self->{isMovie})
            {
                $origtext =~ s/^\s*//m;
                $origtext =~ s/\s*$//m;
                $origtext =~ s|\s*\([[:alpha:].]*\)$||;
                return if !$origtext;
                #$origtext =~ m|^([^/]*?)(/[^(]*)?.*?\(([0-9]{4})\)$|;
                $origtext =~ m|(.*?)\(([0-9]{4})\)$|;
                
                $self->{movieList}[$self->{movieIdx}]->{title} = $1;
                $self->{movieList}[$self->{movieIdx}]->{year} = $2;
                $self->{isMovie} = 0;
            }
        }
        else
        {
            $origtext =~ s/^\s*//m;
            $origtext =~ s/^s*$//m;
                 
            return if !$origtext;       
            if ($self->{isTitle})
            {
                $self->{curInfo}->{title} = $origtext;
                $self->{isTitle} = 0;
            }
            elsif ($self->{isOrig})
            {
                $self->{curInfo}->{orig} = $origtext
                    if $origtext !~ /\(/;
                $self->{isOrig} = 0;   
            }
            elsif ($self->{isCountry})
            {
                $self->{curInfo}->{nat} .= $self->{curInfo}->{nat} ? ", " . $origtext : $origtext;
                $self->{isCountry} = 0;
            }
            elsif ($self->{isGenre})
            {
                $self->{curInfo}->{type} .= $self->{curInfo}->{type} ? ", " . $origtext : $origtext;
                $self->{isGenre} = 0;
            }
            elsif ($self->{isDate})
            {
                $self->{curInfo}->{date} = $origtext;
                $self->{isDate} = 0;   
            }
            elsif ($self->{inside}->{details})
            {
                $origtext =~ m/re.yseria\s*(.+?)\s*scenariusz/gms;
                $self->{curInfo}->{director} = $1;
                $self->{curInfo}->{director} =~ s/\s+/ /g;
                
                $origtext =~ m/od lat: ([0-9]*)/;
                $self->{curInfo}->{age} = $1;

                $origtext =~ m/czas trwania: ([0-9]*)/;
                $self->{curInfo}->{time} = $1;
            }
            elsif ($self->{isActors})
            {
                if ($origtext !~ /^:/)
                {
                    $self->{curInfo}->{actors} .= $self->{curInfo}->{actors} ? ", " . $origtext : $origtext
                        if ($self->{actorsCounter} < $GCPluginParser::MAX_ACTORS);
                    $self->{actorsCounter}++;
                    $self->{isActors} = 0;
                }
            }            
        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{isInfo} = 0;
        $self->{isMovie} = 0;
        $self->{curName} = undef;
        $self->{curUrl} = undef;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;

        $self->{parsingEnded} = 0;
        $self->{insideResults} = 0;
        $self->{actorsCounter} = 0;

        $html =~ s|<\!-- z backup -->(.*?)</div>|<details>$1</details></div>|gms;
        my $details = $1;
        $details =~ s|<a[^>]*>([^<]*)</a>|$1|gms;
        $html =~ s|<details>(.*?)</details>|<details>$details</details>|gms;
        $html =~ s|<span style='color: #8D0000;'>(.*?)</span>|$1|gm;
        $html =~ s|<span style="font-size: 15px">(.*?)</span>|$1|gm;

        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
        return "http://www.filmweb.pl/Find?query=$word&category=1&submit=szukaj";
    }
    
    sub getMovieUrl
    {
		my ($self, $url) = @_;
		
        return $url unless $url eq '';
        return "filmweb.pl";
    }

    sub changeUrl
    {
        my ($self, $url) = @_;
        
        return $url;
    }

    sub getName
    {
        return "FilmWeb";
    }
    
    sub getImageFile
    {
        return "filmaffinity.png";
    }

    sub getCharset
    {
        my $self = shift;
    
        #return "UTF-8";
        return "ISO-8859-2";
    }

    sub getAuthor
    {
        return 'Tian';
    }
    
    sub getLang
    {
        return 'PL';
    }
    sub hasSearchActors
    {
        return 0;
    }

    sub hasSearchDirector
    {
        return 0;
    }
}

1;
