package GCImport::GCImportGCfilms;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;
use GCImport::GCImportBase;

{
    package GCImport::GCImporterGCfilms;
    use base qw(GCImport::GCImportBaseClass);
    
    use GCData;
    
    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();

        bless ($self, $class);
        return $self;
    }

    sub getName
    {
        return "GCfilms (.gcf)";
    }
    
    sub getFilePatterns
    {
       return (['GCfilms (.gcf)', '*.gcf']);
    }
    
    sub getOptions
    {
        my $self = shift;
        my @options;
        return \@options;
    }
    
    # Ignored for the moment
    sub wantsFieldsSelection
    {
        return 0;
    }
    sub getEndInfo
    {
        return "";
    }
    
    sub getMoviesArray
    {
        my ($self, $file) = @_;
        
        my $loader = new GCMovies;
        
        $loader->load($file, undef, undef, 1);
        
        #We need to use only absolute pathes for pictures as we may be somewhere else
        foreach (@{$loader->{movieArray}})
        {
            $_->{image} = GCUtils::getDisplayedImage($_->{image},
                                                     $self->{options}->{parent}->{defaultImage},
                                                     $file);
        }
        
        return $loader->{movieArray};
    }
}

1;
