package GCImport;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use File::Basename;
use FindBin qw($RealBin);

use base 'Exporter';
our @EXPORT = qw(@importersArray);

our @importersArray;

use Cwd;
my $oldCwd = getcwd;
chdir $RealBin;
foreach (glob "../lib/gcfilms/GCImport/*.pm")
{
    my $import = basename($_, '.pm')."\n";
    next if $import =~ /GCImportBase/;
    eval "use GCImport::$import";
    (my $importer = $import) =~ s/^GCImport/GCImporter/;
    my $obj;
    eval "\$obj = new GCImport::$importer";
    die "Fatal error with importer $import\n$@" if $@;
    push @importersArray, $obj if ! $obj->{errors};
}
chdir $oldCwd;

use Gtk2;
use GCDialogs;


{
    package GCImportDialog;
    use base "GCExportImportDialog";


    sub addOptions
    {
        my ($self, $options) = @_;
        $options->{newList} = ($self->{newList}->get_active) ? 1 : 0;
        $options->{parent} = $self->{parent};
    }

    sub new
    {
        my ($proto, $parent) = @_;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new($parent, $parent->{lang}->{ImportListTitle}, 'import');
        bless ($self, $class);

        my $vboxInsert = new Gtk2::VBox(0,0);
        $vboxInsert->set_border_width(0);
        
        $self->{newList} = new Gtk2::RadioButton(undef, $parent->{lang}->{ImportNewList});
        $self->{currentList} = new Gtk2::RadioButton($self->{newList}->get_group, $parent->{lang}->{ImportCurrentList});
                
        $vboxInsert->pack_start($self->{newList},1,1,0);
        $vboxInsert->pack_start($self->{currentList},1,1,0);
        
        $self->vbox->pack_start(new Gtk2::HSeparator, 1, 1, 5);
        $self->vbox->pack_start($vboxInsert,0,0,0);

        $self->{fieldsDialog} = new GCFieldsSelectionDialog($self, $parent->{lang}->{ImportFieldsTitle});
        $self->{fieldsButtonLabel} = $parent->{lang}->{ImportFieldsTitle};
        $self->{fieldsTip} = $parent->{lang}->{ImportFieldsTip};

        return $self;
    }
    
}


1;
