/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote.model;

import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.StatusUpdate;
import com.gallery.GalleryRemote.StatusUpdateAdapter;
import com.gallery.GalleryRemote.model.Gallery;
import com.gallery.GalleryRemote.model.GalleryItem;
import com.gallery.GalleryRemote.model.Picture;
import com.gallery.GalleryRemote.prefs.PreferenceNames;
import com.gallery.GalleryRemote.util.GRI18n;
import com.gallery.GalleryRemote.util.ImageUtils;
import com.gallery.GalleryRemote.util.NaturalOrderComparator;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class Album
extends GalleryItem
implements ListModel,
Serializable,
PreferenceNames {
    public static final String MODULE = "Album";
    ArrayList pictures = new ArrayList();
    String title = GRI18n.getString("Album", "title");
    String name;
    ArrayList extraFields;
    String summary;
    Boolean overrideResize = null;
    Boolean overrideResizeDefault = null;
    int overrideResizeDimension = -1;
    Boolean overrideAddToBeginning = null;
    int autoResize = 0;
    boolean canRead = true;
    boolean canAdd = true;
    boolean canWrite = true;
    boolean canDeleteFrom = true;
    boolean canDeleteThisAlbum = true;
    boolean canCreateSubAlbum = true;
    boolean hasFetchedInfo = false;
    boolean hasFetchedImages = false;
    private transient Long pictureFileSize;
    private transient Integer albumDepth;
    private transient boolean suppressEvents = false;
    public static List extraFieldsNoShow = Arrays.asList("Capture date", "Upload date", "Description");
    public static List extraFieldsNoShowG2 = Arrays.asList("Capture date", "Upload date");
    static final String offendingChars = "\\/*?\"'&<>|.+# ()";
    public static final String INDENT_QUANTUM = "     ";
    protected transient EventListenerList listenerList = new EventListenerList();

    public Album(Gallery gallery) {
        super(gallery);
        this.setAllowsChildren(true);
    }

    public void fetchAlbumProperties(StatusUpdate su) {
        if (!this.hasFetchedInfo && this.getGallery().getComm(su).hasCapability(su, 5)) {
            if (su == null) {
                su = new StatusUpdateAdapter(){};
            }
            try {
                this.gallery.getComm(su).albumInfo(su, this, false);
            }
            catch (RuntimeException e) {
                Log.log(2, MODULE, "Server probably doesn't support album-info");
                Log.logException(2, MODULE, e);
            }
        }
    }

    public void fetchAlbumImages(StatusUpdate su, boolean recursive, int maxPictures) {
        if (this.getGallery().getComm(su).hasCapability(su, 9)) {
            if (su == null) {
                su = new StatusUpdateAdapter(){};
            }
            try {
                this.removeRemotePictures();
                this.gallery.getComm(su).fetchAlbumImages(su, this, recursive, true, maxPictures);
            }
            catch (RuntimeException e) {
                Log.log(2, MODULE, "Server probably doesn't support album-fetch-images");
                Log.logException(2, MODULE, e);
            }
        }
    }

    public void removeRemotePictures() {
        int l = this.pictures.size();
        Iterator it = this.pictures.iterator();
        while (it.hasNext()) {
            Picture picture = (Picture)it.next();
            if (!picture.isOnline()) continue;
            it.remove();
        }
        this.fireContentsChanged(this, 0, l - 1);
    }

    public void moveAlbumTo(StatusUpdate su, Album newParent) {
        if (this.getGallery().getComm(su).hasCapability(su, 10)) {
            if (su == null) {
                su = new StatusUpdateAdapter(){};
            }
            try {
                if (this.gallery.getComm(su).moveAlbum(su, this, newParent, false)) {
                    this.gallery.removeNodeFromParent(this);
                    this.gallery.insertNodeInto(this, newParent, newParent.getChildCount());
                }
            }
            catch (RuntimeException e) {
                Log.log(2, MODULE, "Server probably doesn't support move-album");
                Log.logException(2, MODULE, e);
            }
        }
    }

    public void setServerAutoResize(int autoResize) {
        this.autoResize = autoResize;
        this.hasFetchedInfo = true;
    }

    public int getServerAutoResize() {
        this.fetchAlbumProperties(null);
        return this.autoResize;
    }

    public Gallery getGallery() {
        return this.gallery;
    }

    public Iterator getPictures() {
        return this.pictures.iterator();
    }

    public void addPicture(Picture p) {
        p.setParent(this);
        this.addPictureInternal(p);
        int index = this.pictures.indexOf(p);
        this.fireIntervalAdded(this, index, index);
    }

    public Picture addPicture(File file) {
        Picture p = new Picture(this.gallery, file);
        p.setParent(this);
        this.addPictureInternal(p);
        int index = this.pictures.indexOf(p);
        this.fireIntervalAdded(this, index, index);
        return p;
    }

    public ArrayList addPictures(File[] files) {
        return this.addPictures(files, -1);
    }

    public ArrayList addPictures(File[] files, int index) {
        List expandedFiles = Arrays.asList(files);
        Log.log(3, MODULE, "addPictures: " + expandedFiles);
        try {
            expandedFiles = ImageUtils.expandDirectories(Arrays.asList(files));
        }
        catch (IOException e) {
            Log.logException(1, MODULE, e);
        }
        Log.log(3, MODULE, "addPictures (expanded): " + expandedFiles);
        ArrayList<Picture> pictures = new ArrayList<Picture>(expandedFiles.size());
        Iterator it = expandedFiles.iterator();
        while (it.hasNext()) {
            File f = (File)it.next();
            Picture p = new Picture(this.gallery, f);
            p.setParent(this);
            if (index == -1) {
                this.addPictureInternal(p);
            } else {
                this.addPictureInternal(index++, p);
            }
            pictures.add(p);
        }
        this.fireContentsChanged(this, 0, pictures.size() - 1);
        return pictures;
    }

    public void addPictures(List picturesL) {
        this.addPictures(picturesL, -1);
    }

    public void addPictures(List picturesL, int index) {
        Iterator it = picturesL.iterator();
        while (it.hasNext()) {
            Picture p = (Picture)it.next();
            p.setParent(this);
            if (index == -1) {
                this.pictures.add(p);
                continue;
            }
            this.pictures.add(index++, p);
        }
        this.fireContentsChanged(this, 0, this.pictures.size() - 1);
    }

    private void addPictureInternal(Picture p) {
        this.addPictureInternal(-1, p);
    }

    private void addPictureInternal(int index, Picture p) {
        ImageUtils.AngleFlip af;
        if (GalleryRemote._().properties.getBooleanProperty("exifAutorotate") && p.getExifData() != null && (af = p.getExifData().getTargetOrientation()) != null) {
            p.setFlipped(af.flip);
            p.setAngle(af.angle);
            p.setSuppressServerAutoRotate(true);
        }
        if (index == -1) {
            this.pictures.add(p);
        } else {
            this.pictures.add(index, p);
        }
    }

    public void sortPicturesAlphabetically() {
        Collections.sort(this.pictures, new NaturalOrderComparator());
        this.fireContentsChanged(this, 0, this.pictures.size() - 1);
    }

    public void sortPicturesCreated() {
        Collections.sort(this.pictures, new Comparator(){

            public int compare(Object o1, Object o2) {
                Date d1 = null;
                Date d2 = null;
                Picture p1 = (Picture)o1;
                Picture p2 = (Picture)o2;
                if (p1.getExifData() != null) {
                    d1 = p1.getExifData().getCreationDate();
                }
                if (p2.getExifData() != null) {
                    d2 = p2.getExifData().getCreationDate();
                }
                if (d1 != null && d2 == null) {
                    return 1;
                }
                if (d1 == null && d2 != null) {
                    return -1;
                }
                if (d1 == null && d2 == null) {
                    return 0;
                }
                return d1.compareTo(d2);
            }
        });
        this.fireContentsChanged(this, 0, this.pictures.size() - 1);
    }

    public void sortSubAlbums() {
        if (this.children != null) {
            Collections.sort(this.children, new NaturalOrderComparator());
        }
        this.fireContentsChanged(this, 0, this.pictures.size() - 1);
    }

    public int sizePictures() {
        return this.pictures.size();
    }

    public void clearPictures() {
        int l = this.pictures.size() - 1;
        this.pictures.clear();
        this.fireIntervalRemoved(this, 0, l);
    }

    public void removePicture(int n) {
        this.pictures.remove(n);
        this.fireIntervalRemoved(this, n, n);
    }

    public void removePicture(Picture p) {
        this.removePicture(this.pictures.indexOf(p));
    }

    public void removePictures(int[] indices) {
        int max;
        int min = max = indices[0];
        for (int i = indices.length - 1; i >= 0; --i) {
            this.pictures.remove(indices[i]);
            if (indices[i] > max) {
                max = indices[i];
            }
            if (indices[i] >= min) continue;
            min = indices[i];
        }
        this.fireIntervalRemoved(this, min, max);
    }

    public Picture getPicture(int n) {
        return (Picture)this.pictures.get(n);
    }

    public void setPicture(int n, Picture p) {
        this.pictures.set(n, p);
        this.fireContentsChanged(this, n, n);
    }

    public void setName(String name) {
        this.name = Album.removeOffendingChars(name);
    }

    static String removeOffendingChars(String in) {
        StringBuffer out = new StringBuffer();
        int l = in.length();
        for (int i = 0; i < l; ++i) {
            char c = in.charAt(i);
            if (offendingChars.indexOf(c) != -1) continue;
            out.append(c);
        }
        return out.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setTitle(String title) {
        this.title = title;
        if (!this.suppressEvents) {
            this.gallery.nodeChanged(this);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public long getPictureFileSize() {
        if (this.pictureFileSize == null) {
            this.pictureFileSize = new Long(Album.getPictureFileSize(this.pictures.toArray(new Picture[0])));
        }
        return this.pictureFileSize;
    }

    public static long getPictureFileSize(Picture[] pictures) {
        return Album.getObjectFileSize(pictures);
    }

    public static long getObjectFileSize(Object[] pictures) {
        long total = 0L;
        for (int i = 0; i < pictures.length; ++i) {
            total = (long)((double)total + ((Picture)pictures[i]).getFileSize());
        }
        return total;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.indentHelper(""));
        ret.append(this.title);
        if (this.pictures.size() != 0) {
            ret.append(" (" + this.pictures.size() + ")");
        }
        if (!this.canAdd) {
            ret.append(" ").append(GRI18n.getString(MODULE, "ro"));
        }
        return ret.toString();
    }

    public boolean equals(Object o) {
        return o != null && o instanceof Album && ((Album)o).getGallery() == this.getGallery() && this.getName() != null && ((Album)o).getName() != null && ((Album)o).getName().equals(this.getName());
    }

    public int getSize() {
        return this.pictures.size();
    }

    public Object getElementAt(int index) {
        return this.pictures.get(index);
    }

    public ArrayList getExtraFields() {
        return this.extraFields;
    }

    public void setExtraFieldsString(String extraFieldsString) {
        if (extraFieldsString != null && extraFieldsString.length() > 0) {
            this.extraFields = new ArrayList();
            StringTokenizer st = new StringTokenizer(extraFieldsString, ",");
            List noShow = null;
            noShow = this.getGallery().getGalleryVersion() == 1 ? extraFieldsNoShow : extraFieldsNoShowG2;
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                if (noShow.contains(name) || this.extraFields.contains(name)) continue;
                this.extraFields.add(name);
            }
        } else {
            this.extraFields = null;
        }
    }

    public void setCanRead(boolean b) {
        this.canRead = b;
    }

    public boolean getCanRead() {
        return this.canRead;
    }

    public void setCanAdd(boolean b) {
        this.canAdd = b;
    }

    public boolean getCanAdd() {
        return this.canAdd;
    }

    public void setCanWrite(boolean b) {
        this.canWrite = b;
    }

    public boolean getCanWrite() {
        return this.canWrite;
    }

    public void setCanDeleteFrom(boolean b) {
        this.canDeleteFrom = b;
    }

    public boolean getCanDeleteFrom() {
        return this.canDeleteFrom;
    }

    public void setCanDeleteThisAlbum(boolean b) {
        this.canDeleteThisAlbum = b;
    }

    public boolean getCanDeleteThisAlbum() {
        return this.canDeleteThisAlbum;
    }

    public void setCanCreateSubAlbum(boolean b) {
        this.canCreateSubAlbum = b;
    }

    public boolean getCanCreateSubAlbum() {
        return this.canCreateSubAlbum;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public ArrayList getPicturesList() {
        return this.pictures;
    }

    ArrayList getUploadablePicturesList() {
        ArrayList<Picture> uploadable = new ArrayList<Picture>();
        Iterator it = this.pictures.iterator();
        while (it.hasNext()) {
            Picture picture = (Picture)it.next();
            if (picture.isOnline()) continue;
            uploadable.add(picture);
        }
        return uploadable;
    }

    void setPicturesList(ArrayList pictures) {
        this.pictures = pictures;
        Iterator e = pictures.iterator();
        while (e.hasNext()) {
            ((Picture)e.next()).setParent(this);
        }
        this.fireContentsChanged(this, 0, pictures.size() - 1);
    }

    public int getAlbumDepth() throws IllegalArgumentException {
        if (this.albumDepth == null) {
            this.albumDepth = new Integer(this.depthHelper(0));
        }
        return this.albumDepth;
    }

    int depthHelper(int depth) throws IllegalArgumentException {
        if (this.getParentAlbum() == this || depth > 20) {
            throw new IllegalArgumentException("Circular containment hierarchy. Gallery corrupted!");
        }
        if (this.getParentAlbum() != null) {
            return this.getParentAlbum().depthHelper(depth + 1);
        }
        return depth;
    }

    String indentHelper(String indent) {
        if (this.getParentAlbum() != null) {
            return this.getParentAlbum().indentHelper(indent + INDENT_QUANTUM);
        }
        return indent;
    }

    public Boolean getOverrideResize() {
        return this.overrideResize;
    }

    public void setOverrideResize(Boolean overrideResize) {
        this.overrideResize = overrideResize;
    }

    public Boolean getOverrideResizeDefault() {
        return this.overrideResizeDefault;
    }

    public void setOverrideResizeDefault(Boolean overrideResizeDefault) {
        this.overrideResizeDefault = overrideResizeDefault;
    }

    public int getOverrideResizeDimension() {
        return this.overrideResizeDimension;
    }

    public void setOverrideResizeDimension(int overrideResizeDimension) {
        this.overrideResizeDimension = overrideResizeDimension;
    }

    public Boolean getOverrideAddToBeginning() {
        return this.overrideAddToBeginning;
    }

    public void setOverrideAddToBeginning(Boolean overrideAddToBeginning) {
        this.overrideAddToBeginning = overrideAddToBeginning;
    }

    public boolean getResize() {
        if (this.overrideResize != null) {
            return this.overrideResize;
        }
        return GalleryRemote._().properties.getBooleanProperty("resizeBeforeUpload");
    }

    public boolean getResizeDefault() {
        if (this.overrideResizeDefault != null) {
            return this.overrideResizeDefault;
        }
        return GalleryRemote._().properties.getIntDimensionProperty("resizeTo") == 0;
    }

    public int getResizeDimension() {
        if (this.overrideResizeDimension != -1) {
            return this.overrideResizeDimension;
        }
        return GalleryRemote._().properties.getIntDimensionProperty("resizeTo");
    }

    public boolean getAddToBeginning() {
        if (this.overrideAddToBeginning != null) {
            return this.overrideAddToBeginning;
        }
        return false;
    }

    public boolean isHasFetchedImages() {
        return this.hasFetchedImages;
    }

    public void setHasFetchedImages(boolean hasFetchedImages) {
        this.hasFetchedImages = hasFetchedImages;
    }

    public void setSuppressEvents(boolean suppressEvents) {
        this.suppressEvents = suppressEvents;
    }

    public void addListDataListener(ListDataListener l) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ListDataListener.class, l);
    }

    public void removeListDataListener(ListDataListener l) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.remove(ListDataListener.class, l);
    }

    public void fireContentsChanged(Object source, int index0, int index1) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        Object[] listeners = this.listenerList.getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ListDataListener == null ? Album.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (e == null) {
                e = new ListDataEvent(source, 0, index0, index1);
            }
            ((ListDataListener)listeners[i + 1]).contentsChanged(e);
        }
    }

    public void fireIntervalAdded(Object source, int index0, int index1) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        Object[] listeners = this.listenerList.getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ListDataListener == null ? Album.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (e == null) {
                e = new ListDataEvent(source, 1, index0, index1);
            }
            ((ListDataListener)listeners[i + 1]).intervalAdded(e);
        }
    }

    public void fireIntervalRemoved(Object source, int index0, int index1) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        Object[] listeners = this.listenerList.getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ListDataListener == null ? Album.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (e == null) {
                e = new ListDataEvent(source, 2, index0, index1);
            }
            ((ListDataListener)listeners[i + 1]).intervalRemoved(e);
        }
    }
}

