#   Tab Key Tab Navigate - Epiphany Extension
#   Copyright (C) 2006  Stefan Stuhr
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along
#   with this program; if not, write to the Free Software Foundation, Inc.,
#   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


import gtk
import epiphany

def tktn_set_tab_offset(window, offset):
	notebook = window.get_notebook()

	index = notebook.get_current_page()
	count = notebook.get_n_pages()

	new_index = (index + offset) % count
	notebook.set_current_page(new_index)

def tktn_key_press_cb(window, event):
	if event.state & gtk.gdk.CONTROL_MASK:
		keyvalname = gtk.gdk.keyval_name(event.keyval)
		if keyvalname == "Tab":
			tktn_set_tab_offset(window, 1)
		elif keyvalname == "ISO_Left_Tab":
			tktn_set_tab_offset(window, -1)
		else:
			return False

		return True

def attach_window(window):
	signal = window.connect("key-press-event", tktn_key_press_cb)
	window._tktn_key_press_sig = signal

def detach_window(window):
	if hasattr(window, "_tktn_key_press_sig"):
		window.disconnect(window._tktn_key_press_sig)
		delattr(window, "_tktn_key_press_sig")
