#   Urgent Content Notify - Epiphany Extension
#   Copyright (C) 2006  Stefan Stuhr
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along
#   with this program; if not, write to the Free Software Foundation, Inc.,
#   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


import gtk
import epiphany

def ucn_window_set_focus(window, event):
	window.set_urgency_hint(False)

def attach_window(window):
	if hasattr(window, "get_urgency_hint"):
		signal = window.connect("focus-in-event", ucn_window_set_focus)
		window._ucn_window_set_focus_sig = signal

def detach_window(window):
	if hasattr(window, "_ucn_window_set_focus_sig"):
		window.disconnect(window._ucn_window_set_focus_sig)
		delattr(window, "_ucn_window_set_focus_sig")

		if window.get_urgency_hint():
			window.set_urgency_hint(False)

def ucn_embed_content_change(embed, uri, window):
	if not window.has_focus and hasattr(window, "set_urgency_hint"):
		window.set_urgency_hint(True)

def attach_tab(window, tab):
	if hasattr(tab, "get_embed"):
		embed = tab.get_embed()
	else:
		embed = tab
	try:
		signal = embed.connect("notify::load-status", ucn_embed_content_change, window)
	except:
		signal = embed.connect("ge-content-change", ucn_embed_content_change, window)

	tab._ucn_embed_content_change = signal

def detach_tab(window, tab):
	if not hasattr(tab, "_ucn_embed_content_change"):
		return

	if hasattr(tab, "get_embed"):
		embed = tab.get_embed()
	else:
		embed = tab
	embed.disconnect(tab._ucn_embed_content_change)
	delattr(tab, "_ucn_embed_content_change")

