/*
		      Universal Resource Location
 */

#ifndef URL_H
#define URL_H

#include <glib.h>


typedef struct _url_struct		url_struct;
#define URL(p)				((url_struct *)(p))


/*
 *	URL Flags:
 */
typedef enum {
	URL_PATH_RELATIVE		= (1 << 0)
} url_flags;

/*
 *	URL:
 */
struct _url_struct {

	url_flags	flags;

	/* Protocol ("file", "ftp", "http", "https", etc) */
	gchar		*protocol;

	/* User & Password (may be NULL for none) */
	gchar		*user,
			*password;

	/* Host & Port Number (host may be NULL for none and port
	 * may be 0 for default)
	 */
	gchar		*host;
	gint		port;

	/* Path or Marker (may be NULL for none)
	 *
	 * For recycled objects, this contains the recycled object's
	 * index value as a string
	 */
	gchar		*path;

	/* Path argument, after the '?' character (may be NULL for
	 * none)
	 */
	gchar		*path_arg;

};


extern url_struct *URLNew(void);
extern url_struct *URLNewWithValues(
	const url_flags flags,
	const gchar *protocol,
	const gchar *user,
	const gchar *password,
	const gchar *host,
	const gint port,
	const gchar *path,
	const gchar *path_arg
);
extern url_struct *URLNewFromURLString(const gchar *url_str);
extern url_struct *URLCopy(const url_struct *url);
extern void URLDelete(url_struct *url);

extern guint8 *URLEncode(GList *url_list, gint *buf_len);
extern GList *URLDecode(const guint8 *buf, const gint buf_len);
extern GList *URLDecodeString(const gchar *s);

extern gchar *URLTokenize(const gchar *url_str);
extern gchar *URLDetokenize(const gchar *url_str);


#endif	/* URL_H */
