/* daemon/failmodes.h
 *
 * Failure modes of Entropy Keys
 *
 * Copyright 2009 Simtec Electronics
 *
 * For licence terms refer to the COPYING file.
 */

#ifndef DAEMON_FAILMODES_H
#define DAEMON_FAILMODES_H

/**
 * Entropy Key Failure Modes.
 */
typedef enum {
  /** No failure */
  efm_ok = '0',
  /** Left generator is no longer random */
  efm_raw_left_bad = '1',
  /** Right generator is no longer random */
  efm_raw_right_bad = '2',
  /** Generators have become correlated */
  efm_raw_xor_bad = '3',
  /** Left generator is strongly biassed */
  efm_debias_left_bad = '4',
  /** Right generator is strongly biassed */
  efm_debias_right_bad = '5',
  
  /** Temperature detected below threshold */
  efm_temp_too_low = '7',
  /** Temperature detected above threshold */
  efm_temp_too_high = '8',
  /** FIPS 140-2 tests exceeded threshold for failed blocks */
  efm_fips1402_threshold_exceeded = '9',
  
  /** Voltage too low */
  efm_volt_too_low = 'A',
  /** Voltage too high */
  efm_volt_too_high = 'B',
  
} ekey_failmode_e;

#endif
