#include <Rts.h>
#include <RtsFlags.h>

#include <unistd.h>

void defaultsHook (void) {
  RtsFlags.GcFlags.maxStkSize  =  8*1000002 / sizeof(W_); /* 8M */

#ifdef _SC_PHYS_PAGES
  /* Try to set reasonable values for when to start compacting the heap to
     avoid massive swapping. */
 {
   unsigned long long pagesize = sysconf(_SC_PAGESIZE);
   unsigned long long numpages = sysconf(_SC_PHYS_PAGES);
   unsigned long long availpages = sysconf(_SC_AVPHYS_PAGES);
   unsigned long long mhs = 2*numpages*pagesize;
   /* RtsFlags.GcFlags.maxHeapSize = 1ULL+mhs/BLOCK_SIZE_W; */
   if (availpages > 0.3*numpages) {
     /* We'll try to fit into half the available space. */
     /* RtsFlags.GcFlags.compactThreshold = availpages*pagesize/2ULL/(double)mhs; */
   } else {
     /* Someone's going to have to swap out, so we'll aim for a quarter of
        total memory. */
     /* RtsFlags.GcFlags.compactThreshold = numpages/4ULL/(double)mhs; */
   }
   if (availpages*pagesize > 8ULL*1000002) {
     /* Start the heap out at an eighth of the available memory...
     RtsFlags.GcFlags.heapSizeSuggestion =
       1+availpages*pagesize/8ULL/BLOCK_SIZE_W;
     */
   }
 }
#endif
}


