SET(CMAKE_LIBRARY_PATH_FLAG "libpath ")
SET(CMAKE_LINK_LIBRARY_FLAG "library ")
SET(CMAKE_LINK_LIBRARY_FILE_FLAG "library")

IF(CMAKE_VERBOSE_MAKEFILE)
  SET(CMAKE_WCL_QUIET)
  SET(CMAKE_WLINK_QUIET)
  SET(CMAKE_LIB_QUIET)
ELSE(CMAKE_VERBOSE_MAKEFILE)
  SET(CMAKE_WCL_QUIET "-zq")
  SET(CMAKE_WLINK_QUIET "option quiet")
  SET(CMAKE_LIB_QUIET "-q")
ENDIF(CMAKE_VERBOSE_MAKEFILE)

set(CMAKE_CREATE_WIN32_EXE "system nt_win" )
SET(CMAKE_CREATE_CONSOLE_EXE "system nt" )

SET (CMAKE_EXE_LINKER_FLAGS_DEBUG_INIT "debug all" )
SET (CMAKE_SHARED_LINKER_FLAGS_DEBUG_INIT "debug all" )
SET (CMAKE_EXE_LINKER_FLAGS_RELWITHDEBINFO_INIT "debug all" )
SET (CMAKE_SHARED_LINKER_FLAGS_RELWITHDEBINFO_INIT "debug all" )

set(CMAKE_C_COMPILE_OPTIONS_DLL "-bd") # Note: This variable is a ';' separated list
set(CMAKE_SHARED_LIBRARY_C_FLAGS "-bd") # ... while this is a space separated string.

SET(CMAKE_RC_COMPILER "rc" )

SET(CMAKE_BUILD_TYPE_INIT Debug)
SET (CMAKE_CXX_FLAGS_INIT "-w=3 -xs")
SET (CMAKE_CXX_FLAGS_DEBUG_INIT "-br -bm -d2")
SET (CMAKE_CXX_FLAGS_MINSIZEREL_INIT "-br -bm -os -dNDEBUG")
SET (CMAKE_CXX_FLAGS_RELEASE_INIT "-br -bm -ot -dNDEBUG")
SET (CMAKE_CXX_FLAGS_RELWITHDEBINFO_INIT "-br -bm  -d2 -ot -dNDEBUG")
SET (CMAKE_C_FLAGS_INIT "-w=3 ")
SET (CMAKE_C_FLAGS_DEBUG_INIT "-br -bm -d2 -od")
SET (CMAKE_C_FLAGS_MINSIZEREL_INIT "-br -bm -os -dNDEBUG")
SET (CMAKE_C_FLAGS_RELEASE_INIT "-br -bm -ot -dNDEBUG")
SET (CMAKE_C_FLAGS_RELWITHDEBINFO_INIT "-br -bm -d2 -ot -dNDEBUG")
SET (CMAKE_C_STANDARD_LIBRARIES_INIT "library clbrdll.lib library plbrdll.lib  library kernel32.lib library user32.lib library gdi32.lib library winspool.lib library comdlg32.lib library advapi32.lib library shell32.lib library ole32.lib library oleaut32.lib library uuid.lib library odbc32.lib library odbccp32.lib")
SET (CMAKE_CXX_STANDARD_LIBRARIES_INIT "${CMAKE_C_STANDARD_LIBRARIES_INIT}")

SET(CMAKE_C_CREATE_IMPORT_LIBRARY
  "wlib -c -q -n -b <TARGET_IMPLIB> +'<TARGET_UNQUOTED>'")
SET(CMAKE_CXX_CREATE_IMPORT_LIBRARY ${CMAKE_C_CREATE_IMPORT_LIBRARY})

SET(CMAKE_C_LINK_EXECUTABLE
    "wlink ${CMAKE_START_TEMP_FILE} ${CMAKE_WLINK_QUIET} name '<TARGET_UNQUOTED>' <LINK_FLAGS> option caseexact file {<OBJECTS>} <LINK_LIBRARIES> ${CMAKE_END_TEMP_FILE}")


SET(CMAKE_CXX_LINK_EXECUTABLE ${CMAKE_C_LINK_EXECUTABLE})

# compile a C++ file into an object file
SET(CMAKE_CXX_COMPILE_OBJECT
    "<CMAKE_CXX_COMPILER> ${CMAKE_START_TEMP_FILE} ${CMAKE_WCL_QUIET} <FLAGS> -dWIN32 -d+ <DEFINES> -fo<OBJECT> -c -cc++ <SOURCE>${CMAKE_END_TEMP_FILE}")

# compile a C file into an object file
SET(CMAKE_C_COMPILE_OBJECT
    "<CMAKE_C_COMPILER> ${CMAKE_START_TEMP_FILE} ${CMAKE_WCL_QUIET} <FLAGS> -dWIN32 -d+ <DEFINES> -fo<OBJECT> -c -cc <SOURCE>${CMAKE_END_TEMP_FILE}")

# preprocess a C source file
SET(CMAKE_C_CREATE_PREPROCESSED_SOURCE
    "<CMAKE_C_COMPILER> ${CMAKE_START_TEMP_FILE} ${CMAKE_WCL_QUIET} <FLAGS> -dWIN32 -d+ <DEFINES> -fo<PREPROCESSED_SOURCE> -pl -cc <SOURCE>${CMAKE_END_TEMP_FILE}")

# preprocess a C++ source file
SET(CMAKE_CXX_CREATE_PREPROCESSED_SOURCE
    "<CMAKE_CXX_COMPILER> ${CMAKE_START_TEMP_FILE} ${CMAKE_WCL_QUIET} <FLAGS> -dWIN32 -d+ <DEFINES> -fo<PREPROCESSED_SOURCE> -pl -cc++ <SOURCE>${CMAKE_END_TEMP_FILE}")

SET(CMAKE_CXX_CREATE_SHARED_MODULE
 "wlink ${CMAKE_START_TEMP_FILE} system nt_dll  ${CMAKE_WLINK_QUIET} name '<TARGET_UNQUOTED>' <LINK_FLAGS> option caseexact  file {<OBJECTS>} <LINK_LIBRARIES> ${CMAKE_END_TEMP_FILE}")
SET(CMAKE_CXX_CREATE_SHARED_LIBRARY
  ${CMAKE_CXX_CREATE_SHARED_MODULE}
  ${CMAKE_CXX_CREATE_IMPORT_LIBRARY})

# create a C shared library
SET(CMAKE_C_CREATE_SHARED_LIBRARY ${CMAKE_CXX_CREATE_SHARED_LIBRARY})

# create a C shared module
SET(CMAKE_C_CREATE_SHARED_MODULE ${CMAKE_CXX_CREATE_SHARED_MODULE})

# create a C++ static library
SET(CMAKE_CXX_CREATE_STATIC_LIBRARY  "wlib ${CMAKE_LIB_QUIET} -c -n -b '<TARGET_UNQUOTED>' <LINK_FLAGS> <OBJECTS> ")

# create a C static library
SET(CMAKE_C_CREATE_STATIC_LIBRARY ${CMAKE_CXX_CREATE_STATIC_LIBRARY})

IF(NOT CMAKE_WATCOM_COMPILER_TESTS_RUN)
  SET(CMAKE_WATCOM_COMPILER_TESTS_RUN 1)
  SET(testWatcomVersionFile
    "${CMAKE_ROOT}/Modules/CMakeTestWatcomVersion.c")
  STRING(REGEX REPLACE "/" "\\\\" testWatcomVersionFile "${testWatcomVersionFile}")
  MESSAGE(STATUS "Check for Watcom compiler version")
  SET(CMAKE_TEST_COMPILER ${CMAKE_C_COMPILER})
  IF (NOT CMAKE_C_COMPILER)
    SET(CMAKE_TEST_COMPILER ${CMAKE_CXX_COMPILER})
  ENDIF()
  EXECUTE_PROCESS(COMMAND ${CMAKE_TEST_COMPILER}
    -q -pc \"${testWatcomVersionFile}\"
    OUTPUT_VARIABLE CMAKE_COMPILER_OUTPUT
    RESULT_VARIABLE CMAKE_COMPILER_RETURN
    )
  STRING(REGEX REPLACE "\n" " " compilerVersion "${CMAKE_COMPILER_OUTPUT}")
  STRING(REGEX REPLACE ".*VERSION=(.*)" "\\1"
    compilerVersion "${compilerVersion}")
  IF("${CMAKE_COMPILER_RETURN}" STREQUAL "0")
    SET(WATCOM16)
    SET(WATCOM17)
    SET(WATCOM18)
    SET(WATCOM19)
    IF("${compilerVersion}" LESS 1270)
      SET(WATCOM16 1)
    ENDIF()
    IF("${compilerVersion}" EQUAL 1270)
      SET(WATCOM17 1)
    ENDIF()
    IF("${compilerVersion}" EQUAL 1280)
      SET(WATCOM18 1)
    ENDIF()
    IF("${compilerVersion}" EQUAL 1290)
      SET(WATCOM19 1)
    ENDIF()
  ENDIF()
ENDIF()
