/*
 * main.c
 *
 * Copyright (C) 2003 Bastian Blank <waldi@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $LastChangedBy: bastian $
 * $LastChangedDate: 2005-01-05 22:48:37 +0100 (Mi, 05 Jan 2005) $
 * $LastChangedRevision: 785 $
 */

#include <config.h>

#include <signal.h>
#include <stdlib.h>

#include "download.h"
#include "frontend.h"
#include "install.h"
#include "packages.h"
#include "prepare.h"
#include "suite.h"

static di_packages *packages;
static di_packages_allocator *allocator;
static di_slist *list;

void cleanup_atexit (void)
{
  install_umount ();
}

void cleanup_signal (int signum __attribute__ ((unused)))
{
  install_umount ();
  log_text (DI_LOG_LEVEL_WARNING, "got signal");
  exit (1);
}

int main (int argc, char **argv, char **envp)
{
  atexit (cleanup_atexit);
  signal (SIGHUP, cleanup_signal);
  signal (SIGINT, cleanup_signal);
  signal (SIGPIPE, cleanup_signal);
  signal (SIGTERM, cleanup_signal);

  if (frontend_main (argc, argv, envp))
    log_text (DI_LOG_LEVEL_ERROR, "frontend died");
  return 0;
}

int backend_main (bool download_only)
{
  int ret;

  frontend_progress_start (1000);

  allocator = di_packages_allocator_alloc ();
  if (!allocator)
    return 1;
  ret = download (&packages, allocator, &list);
  if (ret)
    return 1;

  if (download_only)
    return 0;

  ret = install (packages, allocator, list);
  if (ret)
    return 1;
  return 0;

  frontend_progress_stop ();
}

