/*
	transparent.c - animate transparent

	Author:   Susumu Shiohara (shiohara@tpp.epson.co.jp)

		Copyright 1993-1997 by Susumu Shiohara

				All Rights Reserved

*/

#include "xslideshow.h"
#include "animproto.h"

static int windowW, windowH;
static int xof,yof;
static int maxsize;

static void TransparentIt()
{

#if True /* This is the best way to make transparent image */

Position x,y;
Pixel pixel;
XGCValues gcv;
GC gc;
int i,*tmp,tmpindex;

	/* Calculate the center position */
	xof = (windowW - gim.subImageList->width) / 2;
	yof = (windowH - gim.subImageList->height) / 2;

	maxsize = gim.subImageList->width * gim.subImageList->height;

	if( (tmp = (int *)XtMalloc(sizeof(int) * maxsize)) == NULL ){
		fprintf(stderr,"xslideshow: memory allocation error\n");
		goodbyekiss();
	}

	/* Init random position table */
	for(i = 0; i < maxsize; i++)
		tmp[i] = -1;

	for(i = 0; i < maxsize; i++) {

		if(strcmp(app_data.transparentMode,"random") == 0){
			/* Generate random position table */
			while(1){
				tmpindex = myrandom() % maxsize;
				if(tmp[tmpindex] == -1) {
					tmp[tmpindex] = i;
					break;
				}
			}
		}
		else {
			tmpindex = i;
		}

		x = (tmpindex % gim.subImageList->width);
		y = (tmpindex / gim.subImageList->width);

		pixel = XGetPixel(theImage, x, y);

		if(y & 1){
			if(x & 1) {
				gcv.function = GXcopy;
				gcv.foreground = pixel;
				gc = XCreateGC(theDisp, theWindow, GCForeground | GCFunction, &gcv);
				XDrawPoint(theDisp, theWindow, gc, xof + x, yof + y);
				XFreeGC(theDisp,gc);
			}
		}
		else {
			if(!(x & 1)) {
				gcv.function = GXcopy;
				gcv.foreground = pixel;
				gc = XCreateGC(theDisp, theWindow, GCForeground | GCFunction, &gcv);
				XDrawPoint(theDisp, theWindow, gc, xof + x, yof + y);
				XFreeGC(theDisp,gc);
			}
		}
		myusleep(0); /* Flush */
		if(gotSomeAction == True)
			break;
	}

	 myusleep(3000000); /* wait 3 sec */

	/* Re Init random position table */
	for(i = 0; i < maxsize; i++)
		tmp[i] = -1;

	for(i = maxsize - 1; i >= 0; i--) {

		if(strcmp(app_data.transparentMode,"random") == 0){
			/* Generate random position table */
			while(1){
				tmpindex = myrandom() % maxsize;
				if(tmp[tmpindex] == -1) {
					tmp[tmpindex] = i;
					break;
				}
			}
		}
		else {
			tmpindex = i;
		}

		x = (tmpindex % gim.subImageList->width);
		y = (tmpindex / gim.subImageList->width);

		pixel = XGetPixel(theImage, x, y);

		if(y & 1){
			if(!(x & 1)) {
				gcv.function = GXcopy;
				gcv.foreground = pixel;
				gc = XCreateGC(theDisp, theWindow, GCForeground | GCFunction, &gcv);
				XDrawPoint(theDisp, theWindow, gc, xof + x, yof + y);
				XFreeGC(theDisp,gc);
			}
		}
		else {
			if(x & 1) {
				gcv.function = GXcopy;
				gcv.foreground = pixel;
				gc = XCreateGC(theDisp, theWindow, GCForeground | GCFunction, &gcv);
				XDrawPoint(theDisp, theWindow, gc, xof + x, yof + y);
				XFreeGC(theDisp,gc);
			}
		}
		myusleep(0); /* Flush */
		if(gotSomeAction == True)
			break;
	}


	XtFree((char *)tmp);


#else	/* This way (uses the shape combine mask) is not better */

Window win;
int x,y,w,h;
Pixmap pic;
XSetWindowAttributes xswa;
XGCValues gcv;
GC gc;
Pixmap shape;
int i,j,k,l;
unsigned char *mask;

	x = (windowW - gim.subImageList->width) / 2;
	y = (windowH - gim.subImageList->height) / 2;
	w = gim.subImageList->width;
	h = gim.subImageList->height;

	win = XCreateSimpleWindow(theDisp,theWindow,x,y,w,h,0,bcol,bcol);
	xswa.override_redirect = True;
	XChangeWindowAttributes(theDisp,win,CWOverrideRedirect,&xswa);

	pic = XCreatePixmap(theDisp,win,w,h,DefaultDepth(theDisp,theScreenNumber));
	gcv.function = GXcopy;
	gcv.foreground = dbcol;
	gc = XCreateGC(theDisp,pic,GCForeground | GCFunction,&gcv);
	XFillRectangle(theDisp,pic,gc,0,0,w,h);
	XFreeGC(theDisp,gc);

	gcv.function = GXcopy;
	gc = XCreateGC(theDisp,pic,GCFunction,&gcv );
	XPutImage(theDisp,pic,gc,theImage,0,0,0,0,w,h);
	XFreeGC(theDisp,gc);

	mask = (unsigned char *)XtMalloc(sizeof(unsigned char) * w * h);
	k=l=0;
	for(i=0; i<h; i++){
		if(k<1)
			for(j=0; j<w/8; j++)
				mask[i*w/8 + j] = 0xaa;
		else
			for(j=0; j<w/8; j++)
				mask[i*w/8 + j] = 0x55;
		k++;
		if(k==2)
			k=0;
	}
	shape = XCreateBitmapFromData(theDisp,win,mask,w,h);
	XShapeCombineMask(theDisp,win,ShapeBounding,0,0,shape,ShapeSet);
	XtFree((char *)mask);
	XFreePixmap(theDisp,shape);

	XSetWindowBackgroundPixmap(theDisp,win,pic);
	XFreePixmap(theDisp,pic);

	XClearWindow(theDisp,win);
	XMapWindow(theDisp,win);
#endif
}


#if defined(__STDC__) || defined(__cplusplus)
int xtransparentshow(char *fname)
#else
int xtransparentshow(fname)
char *fname;
#endif
{
	windowW = windowWidth;
	windowH = windowHeight;

	PreDisplay2();
	StoreColors(xcolors,gim.subImageList->mapsize);

	if(app_data.showFileName)
		createFileNameWindow(fname);

	TransparentIt();

	if(app_data.showFileName)
		raiseFileNameWindow();

	return(mywait());
}

#if defined(__STDC__) || defined(__cplusplus)
void postxtransparentshow(char *fname)
#else
void postxtransparentshow(fname)
char *fname;
#endif
{
	if(app_data.showFileName)
		removeFileNameWindow();
}

