/*
 * Copyright 1989, 1990, 1991 Jim Frost
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.  The author makes no representations
 * about the suitability of this software for any purpose.  It is
 * provided "as is" without express or implied warranty.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE
 * USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include "xslideshow.h"

extern void goodbyekiss();
extern void myevent();

#if defined(__STDC__) || defined(__cplusplus)
static dword *buildIndex(dword width, dword zoom, dword *rwidth)
#else
static dword *buildIndex(width, zoom, rwidth)
dword width, zoom, *rwidth;
#endif
{ 
double rzoom;
dword *index, a;

	if (!zoom) {
		rzoom= 100.0;
		*rwidth= width;
	}
	else {
		rzoom= (double)zoom / 100.0;
		*rwidth= rzoom * width;
	}

	index= (dword *)XtMalloc(sizeof(dword) * *rwidth);
	if(index ==(dword *)NULL){
		(void) fprintf(stderr,"xslideshow: zoom(),zoom24() memory allocation error.\n");
		goodbyekiss();
	}

	for (a = 0; a < *rwidth; a++) {
		if (zoom)
			*(index + a) = (double)a / rzoom;
		else
			*(index + a) = a;
	}
	return(index);
}

#if defined(__STDC__) || defined(__cplusplus)
void zoom(dword xzoom, dword yzoom)
#else
void zoom(xzoom, yzoom)
dword xzoom, yzoom;
#endif
{ 
dword *xindex, *yindex, xwidth, ywidth;
dword x, y, xsrc, ysrc;
dword srclinelen;
byte *srclinep, *srcptr, *destptr, *destdata;
byte value;

	xindex = buildIndex(gim.subImageList->width, xzoom, &xwidth);
	yindex = buildIndex(gim.subImageList->height, yzoom, &ywidth);

	if(app_data.verbose){
		fprintf(stderr,"xslideshow: zoom() %d%% (%d x %d) -> (%d x %d)\n",
				(int)xzoom, (int)gim.subImageList->width,(int)gim.subImageList->height,(int)xwidth,(int)ywidth);
	}

	destdata = (byte *)XtMalloc(sizeof(byte) * xwidth * ywidth);
	if(destdata ==(byte *)NULL){
		(void) fprintf(stderr,"xslideshow: zoom() memory allocation error.\n");
		goodbyekiss();
	}

	destptr = destdata;
	srclinep = gim.subImageList->image;
	srclinelen = gim.subImageList->width;
	for (y = 0, ysrc = *(yindex + y); y < ywidth; y++) {
		while (ysrc != *(yindex + y)) {
			ysrc++;
			srclinep += srclinelen;
		}
		srcptr = srclinep;
		value = *srcptr;
		for (x = 0, xsrc = *(xindex + x); x < xwidth; x++) {
			if (xsrc != *(xindex + x)) {
				do {
					xsrc++;
					srcptr++;
				} while (xsrc != *(xindex + x));
				value= *srcptr;
			}
			*destptr++ = value;
		}
		myevent();
	}
	XtFree((char *)xindex);
	XtFree((char *)yindex);
	XtFree((char *)(gim.subImageList->image));
	gim.subImageList->image  = destdata;
	gim.subImageList->width  = xwidth;
	gim.subImageList->height = ywidth;
}


#if defined(__STDC__) || defined(__cplusplus)
void zoom24(dword xzoom, dword yzoom)
#else
void zoom24(xzoom, yzoom)
dword xzoom, yzoom;
#endif
{ 
dword *xindex, *yindex, xwidth, ywidth;
dword x, y, xsrc, ysrc;
dword srclinelen;
byte *srclinep, *srcptr, *destptr, *destdata;
byte r,g,b;

	xindex = buildIndex(gim.subImageList->width, xzoom, &xwidth);
	yindex = buildIndex(gim.subImageList->height, yzoom, &ywidth);

	if(app_data.verbose){
		fprintf(stderr,"xslideshow: zoom24() %d%% (%d x %d) -> (%d x %d)\n",
				(int)xzoom, (int)gim.subImageList->width,(int)gim.subImageList->height,(int)xwidth,(int)ywidth);
	}

	destdata = (byte *)XtMalloc(sizeof(byte) * xwidth * ywidth * 3); /* 24 bit */
	if(destdata ==(byte *)NULL){
		(void) fprintf(stderr,"xslideshow: zoom24() memory allocation error.\n");
		goodbyekiss();
	}
	destptr = destdata;
	srclinep = gim.subImageList->image;
	srclinelen = gim.subImageList->width * 3;	/* 24 bit */
	for (y = 0, ysrc = *(yindex + y); y < ywidth; y++) {
		while (ysrc != *(yindex + y)) {
			ysrc++;
			srclinep += srclinelen;
		}
		srcptr = srclinep;
		r = *(srcptr + 0);
		g = *(srcptr + 1);
		b = *(srcptr + 2);
		for (x = 0, xsrc = *(xindex + x); x < xwidth; x++) {
			if (xsrc != *(xindex + x)) {
				do {
					xsrc++;
					srcptr += 3;	/* 24 bit */
				} while (xsrc != *(xindex + x));
				r = *(srcptr + 0);
				g = *(srcptr + 1);
				b = *(srcptr + 2);
			}
			*destptr++ = r;
			*destptr++ = g;
			*destptr++ = b;
		}
		myevent();
	}
	XtFree((char *)xindex);
	XtFree((char *)yindex);
	XtFree((char *)(gim.subImageList->image));
	gim.subImageList->image  = destdata;
	gim.subImageList->width  = xwidth;
	gim.subImageList->height = ywidth;
}

