/************************** color reduction ****************************

	Oomoto's intelligent dithering algorithm

	Author:   Susumu Shiohara (shiohara@tpp.epson.co.jp)

	Copyright 1993-1997 by Ryuuji Oomoto (oomoto@tpp.epson.co.jp)

					All Rights Reserved

************************************************************************/

#include "xslideshow.h"

#if defined(__STDC__) || defined(__cplusplus)
# define P_(s) s
#else
# define P_(s) ()
#endif

extern void myevent P_(());
extern void goodbyekiss P_(());
extern void mediancut P_((int));
extern void quantize P_((int));
extern void nquant P_((int,int));

#define RedPercent		0.299
#define GreenPercent	0.587
#define BluePercent		0.114

static byte color_table[32768];
static byte color_exist[32768];
static int *ee[3],cl[3][256],num[256];
static long buf[2][256];

#if defined(__STDC__) || defined(__cplusplus)
static void privateDitherImage(int clmax)
#else
static void privateDitherImage(clmax)
int clmax;
#endif
{
int i,j,k,clnum,pp,x,y,xmax,ymax;
long dr,dg,db,rr,gg,bb,dr2,dg2,db2,dy,du,dv;
long c,d,lb,lc,ld,le,n0,n1,nn;
dword *color_nm;
byte *hhp,*mp,*srcp,*dstp;

	if(app_data.verbose)
		fprintf(stderr,"xslideshow: privateDitherImage() reduce into %d color\n",clmax);

	xmax=gim.subImageList->width;
	ymax=gim.subImageList->height;
	if(app_data.verbose && app_data.debug)
		fprintf(stderr,"xmax,ymax,clmax=%d,%d,%d\n",xmax,ymax,clmax);

	ee[0] = (int *)XtCalloc(xmax+2, sizeof(int));
	ee[1] = (int *)XtCalloc(xmax+2, sizeof(int));
	ee[2] = (int *)XtCalloc(xmax+2, sizeof(int));

	for(i=0;i<256;i++) {
		j=0;
		if(i & 0x01) j++;
		if(i & 0x02) j++;
		if(i & 0x04) j++;
		if(i & 0x08) j++;
		if(i & 0x10) j++;
		if(i & 0x20) j++;
		if(i & 0x40) j++;
		if(i & 0x80) j++;
		num[i] = j;
	}

/* make 256 color pallet */
	for(i=0;i<1024;i++) color_exist[i] = 0;
	color_nm = (dword *)&color_table[0];
	for(i=0;i<8192;i++) color_nm[i]=0;

	if(clmax < 4) {
		clmax = 2;
		color_nm[0x0088] = 2;
		color_nm[0x1f88] = 2;
		goto get_cl;
	}
	else if(clmax < 8) {
		clmax = 4;
		color_nm[0x0088] = 2;
		color_nm[0x0a4c] = 2;
		color_nm[0x14c4] = 2;
		color_nm[0x1f88] = 2;
		goto get_cl;
	}
	else if(clmax < 16) {
		clmax = 8;
		color_nm[0x0088] = 2;
		color_nm[0x0af7] = 2;
		color_nm[0x0a31] = 2;
		color_nm[0x0a5f] = 2;
		color_nm[0x14b0] = 2;
		color_nm[0x1419] = 2;
		color_nm[0x14df] = 2;
		color_nm[0x1f88] = 2;
		goto get_cl;
	}
	else if(clmax > 256) {
		clmax=256;
	}

	srcp=gim.subImageList->image;
	for(y=0;y<ymax;y++) {
		for(x=0;x<xmax;x++) {
			if(gim.subImageList->bits_per_pixel == 24){
				dr=(int)*srcp++;
				dg=(int)*srcp++;
				db=(int)*srcp++;
			}
			else{
				dr=(int)gim.subImageList->red[*srcp];
				dg=(int)gim.subImageList->green[*srcp];
				db=(int)gim.subImageList->blue[*srcp++];
			}
			dy = ((dword)dr*77
				+ (dword)dg*150
				+ (dword)db*29 + 128)/256;
			du = ((db + ((-dr* 43 -dg*85)/128)+1)/2);
			dv = ((dr + ((-dg*107 -db*21)/128)+1)/2);
			if(clmax < 32 && clmax > 8) {
				dy = (dy/16)+8;
				du = (du+0x90)/32;
				dv = (dv+0x90)/32;
				if(du>7) du=7;
				if(dv>7) dv=7;
			}
			else {
				dy = dy/8;
				du = (du+0x88)/16;
				dv = (dv+0x88)/16;
				if(du>15) du=15;
				if(dv>15) dv=15;
			}
			pp = (dy*256)|(du*16)|(dv);
			color_nm[pp]++;
			mp = &color_exist[pp/8];
			pp = 1 << (pp & 0x7);
			*mp |= pp;
		}
		myevent();
	}

	j = 0;
	clnum = 0;
	for(i=0;i<8192;i++) {
		if(color_nm[i] > 1) clnum++;
	}
	while(clnum > j) {
		for(i=0;i<8192;i++) {
			if(color_nm[i] > 1) {
				color_nm[i] = (color_nm[i]/2) | 1;
				if(color_nm[i] == 1) clnum--;
				if(clnum <= j) break;
			}
		}
		myevent();
		if(app_data.verbose && app_data.debug)
			fprintf(stderr,"%d,",clnum);
	}
	if(app_data.verbose && app_data.debug)
		fprintf(stderr,"static color=%d\n",clnum);
	clmax -= clnum;
	if(clmax == 0) {
			for(i=0;i<1024;i++) color_exist[i] = 0;
			goto get_cl;
	}
	for(i=0;i<8192;i++) {
		if(color_nm[i] > 1) {
			mp = &color_exist[i/8];
			pp = 1 << (i & 0x7);
			*mp ^= pp;
		}
	}
	clnum = 0;
	for(i=0;i<1024;i++) clnum += num[color_exist[i]];
	if(app_data.verbose && app_data.debug)
		fprintf(stderr,"[%d]\n",clnum);
	if(clnum <= clmax) goto get256;

/* down to 256 color */
	n0 = 1;n1 = 65535;

down_loop:
	nn = (n0+n1)/2;
	clnum=0;
	for(i=0;i<256;i++) buf[0][i]=buf[1][i]=0;
	for(k= 0;k< 16;k++) { for(j=0;j<16;j++) {
			lb=0;for(i=0;i<16;i++) {
				pp = (k*256)|((i)*16)|(15-j);mp = &color_exist[pp/8];
				pp = 1 << (pp & 0x7);
				if((*mp) & pp) ld=64; else ld=0;
				d = k & 1;lc = buf[1-d][(j*16) | i]*3;
				if(i)    lc += buf[1-d][(j*16) |(i-1)]*2;
				if(i<15) lc += buf[1-d][(j*16) |(i+1)];
				if(i) lc += buf[d][(j*16) | (i-1)]*3;
				if(j) {
							 lc += buf[d][((j-1)*16) |(i  )]*5;
					if(i<15) lc += buf[d][((j-1)*16) |(i+1)];
				}
				ld += (lc/16);
				if(ld >= 32) {clnum++;ld -= (nn*(16+31-k))/16;}
				buf[d][(j*16) | i] = ld;
			}
		}
		myevent();
	}

	for(i=0;i<256;i++) buf[0][i]=buf[1][i]=0;
	for(k=31;k>=16;k--) { for(j=0;j<16;j++) {
			lb=0;for(i=0;i<16;i++) {
				pp = (k*256)|((i)*16)|(15-j);mp = &color_exist[pp/8];
				pp = 1 << (pp & 0x7);
				if((*mp) & pp) ld=64; else ld=0;
				d = k & 1;lc = buf[1-d][(j*16) | i]*3;
				if(i)    lc += buf[1-d][(j*16) |(i-1)]*2;
				if(i<15) lc += buf[1-d][(j*16) |(i+1)];
				if(i) lc += buf[d][(j*16) | (i-1)]*3;
				if(j) {
							 lc += buf[d][((j-1)*16) |(i  )]*5;
					if(i<15) lc += buf[d][((j-1)*16) |(i+1)];
				}
				ld += (lc/16);
				if(ld >= 32) {clnum++;ld -= (nn*(16+31-k))/16;}
				buf[d][(j*16) | i] = ld;
			}
		}
		myevent();
	}
	if(app_data.verbose && app_data.debug)
		fprintf(stderr,"<%ld,%ld>%ld(%d)\n",n0,n1,nn,clnum);
	if(clnum > clmax) n0 = nn; else n1 = nn;
	if((n1 - n0) > 1) goto down_loop; else {nn = n1;clnum=0;}
	for(i=0;i<256;i++) buf[0][i]=buf[1][i]=0;
	for(k= 0;k< 16;k++) { for(j=0;j<16;j++) {
			lb=0;for(i=0;i<16;i++) {
				pp = (k*256)|((i)*16)|(15-j);mp = &color_exist[pp/8];
				pp = 1 << (pp & 0x7);
				if((*mp) & pp) ld=64; else ld=0;
				d = k & 1;lc = buf[1-d][(j*16) | i]*3;
				if(i)    lc += buf[1-d][(j*16) |(i-1)]*2;
				if(i<15) lc += buf[1-d][(j*16) |(i+1)];
				if(i) lc += buf[d][(j*16) | (i-1)]*3;
				if(j) {
							 lc += buf[d][((j-1)*16) |(i  )]*5;
					if(i<15) lc += buf[d][((j-1)*16) |(i+1)];
				}
				ld += (lc/16);
				if(ld >= 32) {clnum++;ld -= (nn*(16+31-k))/16;*mp |= pp;}
				else *mp &= (0xff-pp);
				buf[d][(j*16) | i] = ld;
			}
		}
		myevent();
	}
	for(i=0;i<256;i++) buf[0][i]=buf[1][i]=0;
	for(k=31;k>=16;k--) { for(j=0;j<16;j++) {
			lb=0;for(i=0;i<16;i++) {
				pp = (k*256)|((i)*16)|(15-j);mp = &color_exist[pp/8];
				pp = 1 << (pp & 0x7);
				if((*mp) & pp) ld=64; else ld=0;
				d = k & 1;lc = buf[1-d][(j*16) | i]*3;
				if(i)    lc += buf[1-d][(j*16) |(i-1)]*2;
				if(i<15) lc += buf[1-d][(j*16) |(i+1)];
				if(i) lc += buf[d][(j*16) | (i-1)]*3;
				if(j) {
							 lc += buf[d][((j-1)*16) |(i  )]*5;
					if(i<15) lc += buf[d][((j-1)*16) |(i+1)];
				}
				ld += (lc/16);
				if(ld >= 32) {clnum++;ld -= (nn*(16+31-k))/16;*mp |= pp;}
				else *mp &= (0xff-pp);
				buf[d][(j*16) | i] = ld;
			}
		}
		myevent();
	}

get256:
	clnum = 0;
	for(i=0;i<1024;i++) clnum += num[color_exist[i]];
	if(app_data.verbose && app_data.debug)
		fprintf(stderr,"[%d]\n",clnum);
	if(clnum > clmax) {
		if(app_data.verbose && app_data.debug)
			fprintf(stderr,"special case,");
		for(i=0;i<1024;i++) {
			d=color_exist[i];
			clnum -= num[d]-num[d & 0xaa];
			color_exist[i] = d & 0xaa;
			if(clnum <= clmax) goto get_cl;
		}
		for(i=0;i<1024;i += 4) {
			for(j=0;j<2;j++) {
				d=color_exist[i+j];
				clnum -= num[d];
				color_exist[i+j] = 0;;
				if(clnum <= clmax) goto get_cl;
			}
		}
		for(i=0;i<1024;i += 64) {
			for(j=0;j<32;j++) {
				d=color_exist[i+j];
				clnum -= num[d];
				color_exist[i+j] = 0;;
				if(clnum <= clmax) goto get_cl;
			}
		}
		if(app_data.verbose && app_data.debug)
			fprintf(stderr,"<<%d>> over %d\n",clnum,clmax);
	}

get_cl:
	clnum=0;
	for(k=0;k<32;k++) {
		for(j=0;j<16;j++) {
			for(i=0;i<16;i++) {
				d = (k*256)|(j*16)|(i);
				mp = &color_exist[d/8];
				if(((*mp & (1 << (d & 0x7))) != 0)||(color_nm[d] > 1)) {
					if(clmax < 32 && clmax > 8) {
						dy = ((k-8)*16)|(k-8);
						du = (j*32);
						dv = (i*32);
					}
					else{
						dy = (k*8)|(k/4);
						du = (j*16);
						dv = (i*16);
					}
					cl[0][clnum] = dy;
					cl[1][clnum] = du;
					cl[2][clnum] = dv;
					clnum++;
				}
			}
		}
		myevent();
	}

	for(i=0;i<32768L;i++) color_exist[i]=0;
	srcp=gim.subImageList->image;
	dstp=gim.subImageList->image;
	for(y=0;y<ymax;y++) {
		rr=gg=bb=0;
		for(x=0;x<xmax;x++) {
			if(gim.subImageList->bits_per_pixel == 24){
				dr=(int)*srcp++;
				dg=(int)*srcp++;
				db=(int)*srcp++;
			}
			else{
				dr=(int)gim.subImageList->red[*srcp];
				dg=(int)gim.subImageList->green[*srcp];
				db=(int)gim.subImageList->blue[*srcp++];
			}
			dy = ((dword)dr*77
				+ (dword)dg*150
				+ (dword)db*29 + 128)/256;
			du = ((db + ((-dr* 43 - dg*85)/128)+1)/2)+128;
			dv = ((dr + ((-dg*107 - db*21)/128)+1)/2)+128;

			dy += (rr+(ee[0][x]*6)+(ee[0][x+1]*4)+(ee[0][x+2]*2)+8)/16;
			du += (gg+(ee[1][x]*6)+(ee[1][x+1]*4)+(ee[1][x+2]*2)+8)/16;
			dv += (bb+(ee[2][x]*6)+(ee[2][x+1]*4)+(ee[2][x+2]*2)+8)/16;
			dr2 = (dy  )/8;
			dg2 = (du+4)/8;
			db2 = (dv+4)/8;
			if(dr2<0) dr2=0; else if(dr2>31) dr2=31;
			if(dg2<0) dg2=0; else if(dg2>31) dg2=31;
			if(db2<0) db2=0; else if(db2>31) db2=31;

			i = (dr2<<10)|(dg2<<5)|(db2);
			hhp = &color_table[i];
			if(color_exist[i]) {
				/* use the existential color */
				j = *hhp;
			} else {
				color_exist[i]=1;
				dr2 = (dr2*8)|(dr2/4);
				dg2 = (dg2*8);
				db2 = (db2*8);
				for(i=0;i<clmax;i++) {
					/* find the most closest color */
					le = dr2-cl[0][i]; c  =le*le;
					le = dg2-cl[1][i]; c +=le*le;
					le = db2-cl[2][i]; c +=le*le;
					if(i == 0 || c < k){ k=c; j=i; }
					else if(c == k && abs(dr2-cl[0][j]) > abs(dr2-cl[0][i])){ j=i; }
				}
				*hhp = j;
			}
			*dstp++=j;

			dy -= cl[0][j];
			du -= cl[1][j];
			dv -= cl[2][j];
			rr=ee[0][x+1];ee[0][x+1]=dy;
			gg=ee[1][x+1];ee[1][x+1]=du;
			bb=ee[2][x+1];ee[2][x+1]=dv;
		}
		myevent();
	}
	XtFree((char *)ee[0]);
	XtFree((char *)ee[1]);
	XtFree((char *)ee[2]);

/* color table */
	if(app_data.verbose && app_data.debug)
		fprintf(stderr,"mapsize = %d\n",clnum);
	for(i=0;i<clnum;i++) {
		dy = cl[0][i];
		du = cl[1][i]-128;
		dv = cl[2][i]-128;
		dr = dy + (((dv)*179+64)/128);
		dg = dy + ((-(du)*44 - (dv)*91+64)/128);
		db = dy + (((du)*227+64)/128);
		if(dr>255) dr=255; else if(dr<0) dr=0;
		if(dg>255) dg=255; else if(dg<0) dg=0;
		if(db>255) db=255; else if(db<0) db=0;
		gim.subImageList->red[i]=dr;    
		gim.subImageList->green[i]=dg;
		gim.subImageList->blue[i]=db;
	}
	gim.subImageList->mapsize=clnum;
	gim.subImageList->bits_per_pixel=8;
	gim.subImageList->image = (byte *)XtRealloc( (char *)gim.subImageList->image,
				sizeof(byte) * gim.subImageList->width * gim.subImageList->height);

	if(app_data.verbose)
		fprintf(stderr, "xslideshow: privateDitherImage() done.\n");

}

/*---------------------------------------------------------------------*/

#if defined(__STDC__) || defined(__cplusplus)
static void globalDitherImage(int clmax)
#else
static void globalDitherImage(clmax)
int clmax;
#endif
{
int mode=0,i,j,k,pix,pixr,pixg,pixb;
int numcolor,dr,dg,db,dr2,dg2,db2;
int	rstep,gstep,bstep;
int	rmax,gmax,bmax;
int	radj,gadj,badj;
int	rhalf,ghalf,bhalf;
int	drmax,dgmax,dbmax;
int	rcolor,gcolor,bcolor;
int	rcolormax,gcolormax,bcolormax;
int	rcolormin,gcolormin,bcolormin;
int *bfr,*bfg,*bfb;
byte *srcp,*dstp;
dword xmax,ymax,r,g,b,mono;
word  red[256],green[256],blue[256];

	if(app_data.verbose)
		fprintf(stderr,"xslideshow: globalDitherImage() reduce into %d color\n",clmax);

	xmax=gim.subImageList->width;
	ymax=gim.subImageList->height;

	rcolor=gcolor=bcolor=7;
	while(1){
		bcolor--; if(rcolor*gcolor*bcolor <= clmax) break;
		rcolor--; if(rcolor*gcolor*bcolor <= clmax) break;
		gcolor--; if(rcolor*gcolor*bcolor <= clmax) break;
		if(rcolor == 2 && gcolor == 2 && bcolor == 2) break;
	}

	if(rcolor == 2 && gcolor == 2 && bcolor == 2 && rcolor*gcolor*bcolor > clmax){

		/* Do 2 color dither */

		if(app_data.verbose)
			fprintf(stderr,
				"xslideshow: globalDitherImage() dithering the image using 2 color (allocatable %d)\n",
					clmax);

		if((dstp = (byte *)XtCalloc(xmax * ymax, sizeof(byte)))==NULL){
			(void) fprintf(stderr,"xslideshow: globalDitherImage() memory allocation error\n");
			goodbyekiss();;
		}
		if((bfr = (int *)XtCalloc(xmax + 4, sizeof(int)))==NULL){
			(void) fprintf(stderr,"xslideshow: globalDitherImage() memory allocation error\n");
			goodbyekiss();;
		}

		red[0]=0;
		red[1]=255;
		srcp=gim.subImageList->image;

		dr2=0;
		for(k=0,j=0;j<(int)ymax;j++){
			for(i=0;i<(int)xmax;i++){
				if(gim.subImageList->bits_per_pixel == 24){
					r=(dword)*srcp++;
					g=(dword)*srcp++;
					b=(dword)*srcp++;
				}
				else{
					r=(dword)gim.subImageList->red[*srcp];
					g=(dword)gim.subImageList->green[*srcp];
					b=(dword)gim.subImageList->blue[*srcp++];
				}
				mono=(dword)(	  (double)r * RedPercent
								+ (double)g * GreenPercent
								+ (double)b * BluePercent	);

				dr = (int)mono + (dr2+bfr[i]*6+bfr[i+1]*4+bfr[i+2]*2+8)/16;
				pix = (dr + 127)/255;
				if(pix < 0) pix = 0; else if(pix > 1) pix = 1;

				/* set the pix */
				dstp[k++] = pix;

				/* set the error */
				dr2 = bfr[i+1];
				bfr[i+1]  = dr - red[pix];
			}
			myevent();
		}
		XtFree((char *)bfr);
		XtFree((char *)gim.subImageList->image);

		gim.subImageList->image   = dstp;
		gim.subImageList->mapsize = 2;
		gim.subImageList->red[0]=gim.subImageList->green[0]=gim.subImageList->blue[0]=0;
		gim.subImageList->red[1]=gim.subImageList->green[1]=gim.subImageList->blue[1]=255;
	}

	else {

		if(	(rcolor == 3 && gcolor == 3 && bcolor == 2)
			||	(rcolor == 2 && gcolor == 3 && bcolor == 2)	){
			rcolor=gcolor=bcolor=2;
		}

		if(app_data.verbose)
			fprintf(stderr,
				"xslideshow: globalDitherImage() dithering the image using %d color (allocatable %d)\n",
					rcolor * gcolor * bcolor, clmax);

		if(mode){
			rcolormax=gcolormax=bcolormax=0;
			rcolormin=gcolormin=bcolormin=255;
			srcp=gim.subImageList->image;
			for(k=0,j=0;j<(int)ymax;j++){
				for(i=0;i<(int)xmax;i++){
					if(gim.subImageList->bits_per_pixel == 24){
						r=(dword)*srcp++;
						g=(dword)*srcp++;
						b=(dword)*srcp++;
					}
					else{
						r=(dword)gim.subImageList->red[*srcp];
						g=(dword)gim.subImageList->green[*srcp];
						b=(dword)gim.subImageList->blue[*srcp++];
					}
					if((int)r < rcolormin) rcolormin=(int)r;	
					if((int)r > rcolormax) rcolormax=(int)r;	
					if((int)g < gcolormin) gcolormin=(int)g;	
					if((int)g > gcolormax) gcolormax=(int)g;	
					if((int)b < bcolormin) bcolormin=(int)b;	
					if((int)b > bcolormax) bcolormax=(int)b;	
				}
				myevent();
			}
		}
		else {
			rcolormax=gcolormax=bcolormax=255;
			rcolormin=gcolormin=bcolormin=0;
		}

		drmax = rcolor - 1;
		dgmax = gcolor - 1;
		dbmax = bcolor - 1;
		rstep = (rcolormax - rcolormin) / drmax;
		gstep = (gcolormax - gcolormin) / dgmax;
		bstep = (bcolormax - bcolormin) / dbmax;
		rmax  = rstep * drmax + rcolormin;
		gmax  = gstep * dgmax + gcolormin;
		bmax  = bstep * dbmax + bcolormin;
		radj  = rcolormax - rmax;
		gadj  = gcolormax - gmax;
		badj  = bcolormax - bmax;
		rhalf = rstep / 2;
		ghalf = gstep / 2;
		bhalf = bstep / 2;
		if((dstp = (byte *)XtCalloc(xmax * ymax, sizeof(byte)))==NULL){
			(void) fprintf(stderr,"xslideshow: globalDitherImage() memory allocation error\n");
			goodbyekiss();;
		}
		if((bfr = (int *)XtCalloc(xmax + 4, sizeof(int)))==NULL){
			(void) fprintf(stderr,"xslideshow: globalDitherImage() memory allocation error\n");
			goodbyekiss();;
		}
		if((bfg = (int *)XtCalloc(xmax + 4, sizeof(int)))==NULL){
			(void) fprintf(stderr,"xslideshow: globalDitherImage() memory allocation error\n");
			goodbyekiss();
		}
		if((bfb = (int *)XtCalloc(xmax + 4, sizeof(int)))==NULL){
			(void) fprintf(stderr,"xslideshow: globalDitherImage() memory allocation error\n");
			goodbyekiss();
		}

		for(numcolor=0,dr=rcolormin;dr<rcolormax+1;dr +=rstep){
			for(dg=gcolormin;dg<gcolormax+1;dg +=gstep){
				for(db=bcolormin;db<bcolormax+1;db +=bstep){
					red[numcolor]=(dr == rcolormin) ? dr : dr+radj;
					green[numcolor]=(dg == gcolormin) ? dg : dg+gadj;
					blue[numcolor]=(db == bcolormin) ? db : db+badj;
					if(app_data.verbose && app_data.debug)
						fprintf(stderr,"(%d,%d,%d) ",red[numcolor],green[numcolor],blue[numcolor]);
					numcolor++;
				}
			}
		}
		if(app_data.verbose && app_data.debug)
			fprintf(stderr,"\n");


		/*
		dr2,dg2,db2 is the upper left pixel of the current pixel
		bfr,bfg,bfb[i] is the left pixel of the current pixel
		bfr,bfg,bfb[i+1] is the upper pixel of the current pixel
		bfr,bfg,bfb[i+2] is the upper right pixel of the current pixel
		*/
		dr2=dg2=db2=0;
		srcp=gim.subImageList->image;
		for(k=0,j=0;j<(int)ymax;j++){
			for(i=0;i<(int)xmax;i++){
				if(gim.subImageList->bits_per_pixel == 24){
					r=(dword)*srcp++;
					g=(dword)*srcp++;
					b=(dword)*srcp++;
				}
				else{
					r=(dword)gim.subImageList->red[*srcp];
					g=(dword)gim.subImageList->green[*srcp];
					b=(dword)gim.subImageList->blue[*srcp++];
				}
				if(r == rcolormax || r == rcolormin)
					dr=(int)r;
				else
					dr=(int)r+(dr2+bfr[i]*6+bfr[i+1]*4+bfr[i+2]*2+8)/16;

				if(g == gcolormax || g == gcolormin)
					dg=(int)g;
				else
					dg=(int)g+(dg2+bfg[i]*6+bfg[i+1]*4+bfg[i+2]*2+8)/16;

				if(b == bcolormax || b == bcolormin)
					db=(int)b;
				else
					db=(int)b+(db2+bfb[i]*6+bfb[i+1]*4+bfb[i+2]*2+8)/16;

				pixr=(dr+rhalf-rcolormin)/rstep;
				pixg=(dg+ghalf-gcolormin)/gstep;
				pixb=(db+bhalf-bcolormin)/bstep;

				if(pixr<0) pixr=0; else if(pixr>drmax) pixr=drmax;
				if(pixg<0) pixg=0; else if(pixg>dgmax) pixg=dgmax;
				if(pixb<0) pixb=0; else if(pixb>dbmax) pixb=dbmax;

				pix=((pixr * gcolor) + pixg) * bcolor + pixb;
				dstp[k++]=pix;

				/* set the error */
				dr2=bfr[i+1];
				dg2=bfg[i+1];
				db2=bfb[i+1];
				bfr[i+1]=dr-red[pix];
				bfg[i+1]=dg-green[pix];
				bfb[i+1]=db-blue[pix];
			}
			myevent();
		}

		XtFree((char *)bfr);
		XtFree((char *)bfg);
		XtFree((char *)bfb);
		XtFree((char *)gim.subImageList->image);

		for(i=0;i<numcolor;i++){
			gim.subImageList->red[i]=red[i];
			gim.subImageList->green[i]=green[i];
			gim.subImageList->blue[i]=blue[i];
		}
		gim.subImageList->image=dstp;
		gim.subImageList->mapsize=numcolor;

	}

	gim.subImageList->bits_per_pixel=8;

	if(app_data.verbose)
		fprintf(stderr, "xslideshow: globalDitherImage() done.\n");
}

/*---------------------------------------------------------------------*/

static void conv24bitTo16bitImage()
{
byte *sptr,r,g,b;
word *dptr,wdata;
int	i,j;
dword mask,r_bits=0,g_bits=0,b_bits=0;
dword r_shift=0,g_shift=0,b_shift=0;

	if(app_data.verbose)
		fprintf(stderr,"xslideshow: conv24bitTo16bitImage() reduce into 5x6x5 bit (65536 color)\n");

	mask=gim.visual.red_mask;
	do { if(mask & 1) break; mask >>= 1; r_shift++; } while(mask);
	do { if(mask & 0x80) break; mask <<= 1; r_bits++; } while(mask);

	mask=gim.visual.green_mask;
	do { if(mask & 1) break; mask >>= 1; g_shift++; } while(mask);
	do { if(mask & 0x80) break; mask <<= 1; g_bits++; } while(mask);

	mask=gim.visual.blue_mask;
	do { if(mask & 1) break; mask >>= 1; b_shift++; } while(mask);
	do { if(mask & 0x80) break; mask <<= 1; b_bits++; } while(mask);

	sptr=gim.subImageList->image;
	dptr=(word *)sptr;
	if(theDepth <= 16){
		for(j=0;j<gim.subImageList->height;j++){
			for(i=0;i<gim.subImageList->width;i++){
				wdata = 0;
				if(r_shift < r_bits) {
					wdata |= (*sptr)>>(r_bits - r_shift) & gim.visual.red_mask; sptr++;
				}
				else {
					wdata |= (*sptr)<<(r_shift - r_bits) & gim.visual.red_mask; sptr++;
				}

				if(g_shift < g_bits) {
					wdata |= (*sptr)>>(g_bits - g_shift) & gim.visual.green_mask; sptr++;
				}
				else {
					wdata |= (*sptr)<<(g_shift - g_bits) & gim.visual.green_mask; sptr++;
				}

				if(b_shift < b_bits) {
					wdata |= (*sptr)>>(b_bits - b_shift) & gim.visual.blue_mask; sptr++;
				}
				else {
					wdata |= (*sptr)<<(b_shift - b_bits) & gim.visual.blue_mask; sptr++;
				}

				*dptr++ = wdata;
			}
		}
	}
	else { /* 8+8+8 -> 5+6+5 = 65536 colors */
		for(j=0;j<gim.subImageList->height;j++){
			for(i=0;i<gim.subImageList->width;i++){
				r= *sptr++;
				g= *sptr++;
				b= *sptr++;
				wdata=PUT_RGB565(r,g,b);
				*dptr++ = wdata;
			}
		}
	}

	gim.subImageList->image = (byte *)XtRealloc((char *)gim.subImageList->image, sizeof(word) * gim.subImageList->width * gim.subImageList->height);
	gim.subImageList->bits_per_pixel = 16;

	if(app_data.verbose)
		fprintf(stderr, "xslideshow: conv24bitTo16bitImage() done.\n");
}

/*---------------------------------------------------------------------*/


#if defined(__STDC__) || defined(__cplusplus)
void reduceColorNum(int bits, int numcolor)
#else
void reduceColorNum(bits, numcolor)
int bits;
int numcolor;
#endif
{
	if(useGlobalCmap) {
		globalDitherImage(numcolor);
	}
	else if(bits == 16 && gim.subImageList->bits_per_pixel == 24) {
		conv24bitTo16bitImage();
	}
	else {
		if(gim.subImageList->bits_per_pixel == 8
		&& gim.subImageList->mapsize <= numcolor)
			return;

		if(!strcmp(app_data.reduce,"mediancut"))
			/* Heckbert's median cut algorithm */
			mediancut(numcolor);
		else if(!strcmp(app_data.reduce,"quantize"))
			/* E. I. du Pont de Nemours & Company 's quantize algorithm */
			quantize(numcolor);
		else if(!strcmp(app_data.reduce,"nquant"))
			/* Anthony Dekker's Kohonen Neural Network algorithm */
			nquant(numcolor, 30);	/* fast 30, 10, 3, 1 slow*/
		else
			/* Oomoto's intelligent dithering algorithm */
			privateDitherImage(numcolor);
	}
}

